/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventTargetAddress;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMountWidgetSet
implements IRemoteSkinEvent {
    private static final String WIDGET_SET_ID_TO_MOUNT = "mount";
    private static final String OWNER = "owner";
    private static final String PARENT = "parent";
    private static final String WIDGET_ID_TO_SHOW = "show";
    private static final String TRANSACTION_ID = "transactionId";
    private final CWidgetSetId mWidgetSetToMount;
    private final CTargetAddress mOwner;
    private final CWidgetId mParent;
    private final String mWidgetToShow;
    private final UUID mTransactionId;

    public CEventMountWidgetSet(@NotNull CWidgetSetId aWidgetSetToMount, @NotNull CTargetAddress aOwner, @Nullable CWidgetId aParent, @Nullable String aWidgetToShow, @Nullable UUID aTransactionId) {
        this.mWidgetSetToMount = aWidgetSetToMount;
        this.mOwner = aOwner;
        this.mParent = aParent;
        this.mWidgetToShow = aWidgetToShow;
        this.mTransactionId = aTransactionId;
    }

    @Nullable
    public static CEventMountWidgetSet create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(WIDGET_SET_ID_TO_MOUNT);
            CEventWidgetSetId toMount = CEventWidgetSetId.create(o);
            CEventTargetAddress eventOwner = CEventTargetAddress.create(jo.getValue(OWNER));
            String s = CUtilString.fromObject((Object)jo.getValue(TRANSACTION_ID), (String)"");
            UUID transactionId = null;
            if (CUtilString.isValid((String)s)) {
                transactionId = CUtilUuid.fromString((String)s);
            }
            if (toMount != null && eventOwner != null) {
                o = jo.getValue(PARENT);
                CEventWidgetId parent = CEventWidgetId.create(o);
                String toShow = CUtilJsonString.fromJson((CJsonObject)jo, (String)WIDGET_ID_TO_SHOW, null);
                return new CEventMountWidgetSet(toMount.getWidgetSetId(), eventOwner.getTargetAddress(), parent == null ? null : parent.getWidgetId(), toShow, transactionId);
            }
        }
        return null;
    }

    @NotNull
    public CWidgetSetId getWidgetSetToMount() {
        return this.mWidgetSetToMount;
    }

    @Nullable
    public CWidgetId getParent() {
        return this.mParent;
    }

    @Nullable
    public String getWidgetToShow() {
        return this.mWidgetToShow;
    }

    @NotNull
    public CTargetAddress getOwner() {
        return this.mOwner;
    }

    @Nullable
    public UUID getTransactionId() {
        return this.mTransactionId;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        CEventWidgetSetId dws = new CEventWidgetSetId(this.mWidgetSetToMount);
        jo.put(WIDGET_SET_ID_TO_MOUNT, dws.toJson());
        CEventTargetAddress event = new CEventTargetAddress(this.mOwner);
        jo.put(OWNER, event.toJson());
        if (this.mParent != null) {
            CEventWidgetId p = new CEventWidgetId(this.mParent);
            jo.put(PARENT, p.toJson());
        }
        if (CUtilString.isValid((String)this.mWidgetToShow)) {
            jo.put(WIDGET_ID_TO_SHOW, (Object)this.mWidgetToShow);
        }
        if (this.mTransactionId != null) {
            jo.put(TRANSACTION_ID, (Object)this.mTransactionId.toString());
        }
        return jo;
    }
}

