/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventDimension
implements IRemoteSkinEvent {
    static final String WIDTH = "width";
    static final String HEIGHT = "height";
    static final int DEFAULT_WIDTH = -1;
    static final int DEFAULT_HEIGHT = -1;
    private final Dimension mDimension = new Dimension();

    public CEventDimension(int aWidth, int aHeight) {
        this.mDimension.width = aWidth;
        this.mDimension.height = aHeight;
    }

    public CEventDimension(@Nullable Dimension aDimension) {
        this.mDimension.width = aDimension == null ? -1 : aDimension.width;
        this.mDimension.height = aDimension == null ? -1 : aDimension.height;
    }

    @Nullable
    public static CEventDimension create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int width = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)WIDTH, (int)-1);
            int height = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)HEIGHT, (int)-1);
            return new CEventDimension(width, height);
        }
        if (aValue instanceof Dimension) {
            return new CEventDimension((Dimension)aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mDimension.width >= 0) {
            jo.put(WIDTH, (Object)this.mDimension.width);
        }
        if (this.mDimension.height >= 0) {
            jo.put(HEIGHT, (Object)this.mDimension.height);
        }
        return jo;
    }

    @NotNull
    public Dimension getDimension() {
        return this.mDimension;
    }
}

