/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventAddTab
implements IRemoteSkinEvent {
    public static final String WIDGET_SET_ID = "wsId";
    public static final String TITLE = "title";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    private final CWidgetSetId mWidgetSetId;
    private final String mTitle;
    private final String mToolTip;
    private final String mIconPath;

    public CEventAddTab(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aTitle, @NotNull String aToolTip, @NotNull String aIconPath) {
        this.mWidgetSetId = aWidgetSetId;
        this.mTitle = aTitle;
        this.mToolTip = aToolTip;
        this.mIconPath = aIconPath;
    }

    @Nullable
    public static CEventAddTab create(@Nullable Object aValue) {
        CJsonObject jo;
        CEventWidgetSetId widgetSetId;
        if (aValue instanceof CJsonObject && (widgetSetId = CEventWidgetSetId.create((jo = (CJsonObject)aValue).getValue(WIDGET_SET_ID))) != null) {
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)TITLE, (String)"");
            String toolTip = CUtilJsonString.fromJson((CJsonObject)jo, (String)TOOLTIP, (String)"");
            String iconPath = CUtilJsonString.fromJson((CJsonObject)jo, (String)ICON, (String)"");
            return new CEventAddTab(widgetSetId.getWidgetSetId(), title, toolTip, iconPath);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        CEventWidgetSetId event = new CEventWidgetSetId(this.mWidgetSetId);
        jo.put(WIDGET_SET_ID, event.toJson());
        jo.put(TITLE, (Object)this.mTitle);
        jo.put(TOOLTIP, (Object)this.mToolTip);
        jo.put(ICON, (Object)this.mIconPath);
        return jo;
    }

    @NotNull
    public CWidgetSetId getWidgetSetId() {
        return this.mWidgetSetId;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    @NotNull
    public String getToolTip() {
        return this.mToolTip;
    }

    @NotNull
    public String getIconPath() {
        return this.mIconPath;
    }
}

