/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editpreferences;

import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceNode;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceTree;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceValue;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class CPreferenceTreeBuilder {
    CPreferenceTreeBuilder() {
    }

    public static void main(@NotNull String[] aArgs) {
        CStringProperties preferencesMap = new CStringProperties();
        preferencesMap.put("/nodes/key1", "value1");
        preferencesMap.put("/nodes/subnode1/key2", "value2");
        preferencesMap.put("/nodes/subnode1/subsubnode/key3", "value3");
        preferencesMap.put("/nodes/subnode2/key4", "value4");
        CPreferenceTree tree = CPreferenceTreeBuilder.buildPreferenceTreeFromKeys(preferencesMap);
        CPreferenceTreeBuilder.printPreferenceTree(tree.getRoot(), 0);
    }

    @NotNull
    public static CPreferenceTree buildPreferenceTreeFromNodes(@NotNull @NotNull String @NotNull [] aNodePaths) {
        String id = CPreferenceTree.createNodeId("");
        CPreferenceNode root = new CPreferenceNode(id, null, "", "root");
        CPreferenceTree tree = new CPreferenceTree(root);
        for (String path : aNodePaths) {
            CPreferenceTreeBuilder.addPathToTree(tree, root, path);
        }
        return tree;
    }

    private static void addPathToTree(@NotNull CPreferenceTree aTree, @NotNull CPreferenceNode aRoot, @NotNull String aPath) {
        if (CUtilString.isEmpty((String)aPath)) {
            return;
        }
        String inPath = aPath.startsWith("/") ? aPath.substring(1) : aPath;
        String[] segments = inPath.split("/");
        CPreferenceNode currentNode = aRoot;
        String path = "";
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            path = i == 0 ? segment : path + "/" + segment;
            CPreferenceNode node = currentNode.getChildNodes().get(segment);
            if (node == null) {
                String id = CPreferenceTree.createNodeId(inPath);
                node = new CPreferenceNode(id, currentNode, path, segment);
                currentNode.getChildNodes().put(segment, node);
                aTree.addNode(node);
            }
            currentNode = currentNode.getChildNodes().get(segment);
        }
    }

    public static void addKeyValuePairs(@NotNull CPreferenceTree aTree, @NotNull CStringProperties aKeyValuePairs) {
        for (String pathKey : aKeyValuePairs.getKeys()) {
            CPreferenceNode node;
            String key;
            String path;
            int pos = pathKey.lastIndexOf(47);
            if (pos != -1) {
                path = pathKey.substring(0, pos);
                key = pathKey.substring(pos + 1);
            } else {
                path = "";
                key = pathKey;
            }
            if ((node = aTree.getPreferenceNode(path)) == null) continue;
            String value = aKeyValuePairs.get(pathKey);
            String id = CPreferenceTree.createKeyValueId(pathKey);
            CPreferenceValue valueNode = new CPreferenceValue(node, id, key, value);
            node.getKeyValues().put(key, valueNode);
            aTree.addNode(valueNode);
        }
    }

    @NotNull
    public static CPreferenceTree buildPreferenceTreeFromKeys(@NotNull CStringProperties aPreferencesMap) {
        String id = CPreferenceTree.createNodeId("");
        CPreferenceNode root = new CPreferenceNode(id, null, "/", "root");
        CPreferenceTree tree = new CPreferenceTree(root);
        for (String key : aPreferencesMap.getKeys()) {
            String value = aPreferencesMap.get(key);
            CPreferenceTreeBuilder.addPathToTree(tree, root, key, value);
        }
        return tree;
    }

    private static void addPathToTree(@NotNull CPreferenceTree aTree, @NotNull CPreferenceNode aRoot, @NotNull String aPath, @NotNull String aValue) {
        String inPath = aPath.startsWith("/") ? aPath.substring(1) : aPath;
        String[] segments = inPath.split("/");
        CPreferenceNode currentNode = aRoot;
        String path = "";
        for (int i = 0; i < segments.length - 1; ++i) {
            String segment = segments[i];
            path = i == 0 ? segment : path + "/" + segment;
            CPreferenceNode node = currentNode.getChildNodes().get(segment);
            if (node == null) {
                String id = CPreferenceTree.createNodeId(inPath);
                node = new CPreferenceNode(id, currentNode, path, segment);
                currentNode.getChildNodes().put(segment, node);
                aTree.addNode(node);
            }
            currentNode = currentNode.getChildNodes().get(segment);
        }
        String key = segments[segments.length - 1];
        String id = CPreferenceTree.createKeyValueId(inPath);
        CPreferenceValue value = new CPreferenceValue(currentNode, id, key, aValue);
        currentNode.getKeyValues().put(key, value);
        aTree.addNode(value);
    }

    private static void printPreferenceTree(@NotNull CPreferenceNode aNode, int aIndent) {
        String indentStr = CUtilString.create((char)' ', (int)(aIndent * 2));
        System.out.println(indentStr + aNode.getNodeName() + ": " + String.valueOf(aNode.getKeyValues()));
        for (CPreferenceNode child : aNode.getChildNodes().values()) {
            CPreferenceTreeBuilder.printPreferenceTree(child, aIndent + 1);
        }
    }
}

