/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.webserver.CWebServer;
import de.sillysky.nyssr.impl.webserver.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CWebServerFactory
implements IService {
    private final IDependencies mDependencies;
    private CWebServer mWebServer;

    CWebServerFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences preferences = kc.getPreferences("webserver");
        int port = preferences.getInt("port", 8080);
        String webroot = preferences.get("webroot", "webroot");
        Path storagePath = kc.getStoragePath();
        if (storagePath == null) {
            throw new CException(2202).append("No web root found");
        }
        Path path = Paths.get(webroot, new String[0]);
        if (!path.toFile().exists()) {
            path = storagePath.resolve(webroot);
            CUtilFile.createDirectories((Path)path);
            if (!path.toFile().exists()) {
                throw new CException(2202).append("Couldn't create web root ").append((Object)path);
            }
            preferences.put("webroot", path.toString());
        }
        this.mWebServer = new CWebServer(port, path);
        this.mWebServer.start();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mWebServer.stop();
        this.mWebServer = null;
    }
}

