/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.nodemanager.main;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.nodemanager.main.CConstants;
import de.sillysky.nyssr.impl.web.dialog.nodemanager.main.IDependencies;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.kernel.configuration.ESystemExit;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.network.connection.records.CRecordDataConnection;
import de.sillysky.nyssr.network.link.CLinkDto;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordGetNodeInfo;
import de.sillysky.nyssr.network.records.CRecordNetworkGetConnection;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetLinks;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfReachableNodes;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyUpdateNodeLinkList;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CAbstractWebDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.software.updater.records.CRecordReboot;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C00402NodeManagerMain
extends CAbstractWebDialog {
    private static final IId MICRO_SERVICE_EDIT_CONFIG_FILES = CIdFactory.fromObject((Object)"NY_WebDialogEditConfigFiles_00403");
    private static final IId MICRO_SERVICE_EDIT_PREFERENCES = CIdFactory.fromObject((Object)"NY_WebDialogEditPreferences_00404");
    private static final String ID_00402_NODE_MANAGER_MAIN = "id_00402_node_manager_main";
    private static final String ID_00402_DETAILS = "id_00402_details";
    private static final String ID_00402_DETAILS_IMPL = "id_00402_details_impl";
    private static final String ID_00402_MODAL = "id_00402_modal";
    private static final String ID_SCRIPT1 = "id_00402_graph";
    private static final String ID_SCRIPT2 = "id_00402_d3js";
    private static final String ID_SCRIPT3 = "id_00402_update";
    private static final String ID_CSS = "id_00402_css";
    private static final String ID_CSS_NODES = "id_00402_css_nodes";
    private static final String ID_NODE_CONTEXT_MENU = "id_00402_node_context_menu";
    private static final String ID_NODE_REBOOT = "id_00402_reboot_node";
    private static final String ID_NODE_EDIT_CONFIG_FILES = "id_00402_edit_config_files";
    private static final String ID_NODE_EDIT_PREFERENCES = "id_00402_edit_preferences";
    private static final String[] WIDGETS = new String[]{"id_00402_reboot_node", "id_00402_edit_config_files", "id_00402_edit_preferences"};
    private static final String PREFIX_NODE = "id_node_";
    private static final String PREFIX_LINK = "id_link_";
    private final IDependencies mDependencies;
    private final TreeSet<CNodeAddress> mNodeAddresses = new TreeSet((aInfo1, aInfo2) -> {
        String info1 = aInfo1.getNodeId().toString();
        String info2 = aInfo2.getNodeId().toString();
        return info1.compareTo(info2);
    });
    private final Map<UUID, CLinkDto> mLinks = new HashMap<UUID, CLinkDto>();
    private boolean mUpdate = false;
    private CNodeId mCurrentNodeId = null;
    private UUID mCurrentLinkId = null;

    public C00402NodeManagerMain(@NotNull IDependencies aDependencies, byte[] aSessionToken, @NotNull CTargetAddress aRemoteSkinAddress, @NotNull CTargetAddress aOwnerAddress, @NotNull String aParentWidgetId) {
        super(aSessionToken, aRemoteSkinAddress, aOwnerAddress, aParentWidgetId, CConstants.MICRO_SERVICE_ID);
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkGetListOfReachableNodes.ID, this::asyncNetworkGetListOfReachableNodes);
        this.addMessageHandler(CRecordNetworkGetLinks.ID, this::asyncNetworkGetLinks);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncNotifyClick2);
        this.addMessageHandler(CRecordGetNodeInfo.ID, this::asyncGetNodeInfo);
        this.addMessageHandler(CRecordNetworkGetConnection.ID, this::asyncNetworkGetConnection);
        this.addMessageHandler(CRecordNetworkNotifyUpdateNodeLinkList.ID, this::asyncNetworkNotifyUpdateNodeLinkList);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IRecordHelper rh = this.mDependencies.getRecordHelper();
        rh.addObserver(CRecordNotifyRemoteNodeAdded.class, (ITarget)this, false);
        rh.addObserver(CRecordNotifyRemoteNodeRemoved.class, (ITarget)this, false);
        rh.addObserver(CRecordNetworkNotifyUpdateNodeLinkList.class, (ITarget)this, false);
        this.getWebApi().registerWidgets(WIDGETS);
        this.sendGetNodeData();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNetworkGetListOfReachableNodes(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mNodeAddresses.clear();
            CNodeAddress[] addresses = CRecordNetworkGetListOfReachableNodes.getNodes((CRecord)aRecord, null);
            if (addresses != null) {
                this.mNodeAddresses.addAll(Arrays.asList(addresses));
                this.sendGetLinks();
            }
            return true;
        }
        return false;
    }

    private boolean asyncNetworkGetLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] records = CRecordNetworkGetLinks.getLinks((CRecord)aRecord, null);
            if (records != null) {
                this.mLinks.clear();
                for (CRecord record : records) {
                    CLinkDto linkDto = CLinkDto.fromRecord((CRecord)record);
                    this.mLinks.put(linkDto.getConnectionId(), linkDto);
                }
                this.registerIds();
                if (!this.mUpdate) {
                    this.addCss();
                    this.showDialog();
                    this.addJs();
                    this.getWebApi().addScript(ID_SCRIPT2, null, "https://d3js.org/d3.v7.min.js", "loadFile2");
                    this.updateJs();
                    this.mUpdate = true;
                } else {
                    this.updateJs();
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendGetNodeData();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendGetNodeData();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNetworkNotifyUpdateNodeLinkList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendGetNodeData();
        aEnvelope.setResultSuccess();
        return true;
    }

    public boolean asyncNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, (String)"");
        if (id.startsWith(PREFIX_NODE)) {
            String nodeName = id.substring(PREFIX_NODE.length());
            CNodeId oldId = this.mCurrentNodeId;
            this.mCurrentNodeId = new CNodeId(nodeName);
            this.setNodeStyles(oldId, this.mCurrentNodeId);
            this.getNodeInfo(this.mCurrentNodeId);
        } else if (id.startsWith(PREFIX_LINK)) {
            UUID oldLinkId = this.mCurrentLinkId;
            String s = id.substring(PREFIX_LINK.length());
            this.mCurrentLinkId = CUtilUuid.fromString((String)s);
            this.setLinkStyles(oldLinkId, this.mCurrentLinkId);
            CLinkDto linkDto = this.mLinks.get(this.mCurrentLinkId);
            if (linkDto != null) {
                this.sendGetLinkData(linkDto);
            }
        } else if (ID_NODE_REBOOT.equals(id)) {
            this.getWebApi().removeClassFromElement("#id_00402_node_context_menu", "uk-open");
            this.reboot(this.mCurrentNodeId);
        } else if (ID_NODE_EDIT_CONFIG_FILES.equals(id)) {
            this.openDialogEditConfigFiles();
        } else if (ID_NODE_EDIT_PREFERENCES.equals(id)) {
            this.openDialogEditPreferences();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetNodeInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord nodeInfo;
            CNodeInfo info;
            if (aEnvelope.getResultCode() == 0 && (info = CNodeInfo.create((CRecord)(nodeInfo = CRecordGetNodeInfo.getNodeInfo((CRecord)aRecord, null)))) != null) {
                this.updateDetailsNode(info);
            }
            return true;
        }
        return false;
    }

    private boolean asyncNetworkGetConnection(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord record;
            if (aEnvelope.getResultCode() == 0 && (record = CRecordNetworkGetConnection.getConnection((CRecord)aRecord, null)) != null) {
                UUID connectionId = CRecordDataConnection.getConnectionId((CRecord)record, null);
                CLinkDto linkDto = this.mLinks.get(connectionId);
                boolean incoming = CRecordDataConnection.getIncoming((CRecord)record, (boolean)false);
                String localAddress = CRecordDataConnection.getLocalAddress((CRecord)record, (String)"");
                String remoteAddress = CRecordDataConnection.getRemoteAddress((CRecord)record, (String)"");
                CNodeAddress remoteNodeAddress = CRecordDataConnection.getRemoteNodeAddress((CRecord)record, null);
                UUID remoteInstanceId = CRecordDataConnection.getRemoteInstanceId((CRecord)record, null);
                String connectionType = CRecordDataConnection.getConnectionType((CRecord)record, (String)"");
                String connectionUsage = CRecordDataConnection.getConnectionUsage((CRecord)record, (String)"");
                CTargetAddress targetAddress = CRecordDataConnection.getTargetAddress((CRecord)record, null);
                this.updateDetailsLink(linkDto, incoming, localAddress, remoteAddress, remoteNodeAddress, remoteInstanceId, connectionType, connectionUsage, targetAddress);
            }
            return true;
        }
        return false;
    }

    private void reboot(CNodeId aCurrentNodeId) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordReboot.class, (CNodeAddress)new CNodeAddress(aCurrentNodeId));
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordReboot.create();
        CRecordReboot.setCode((CRecord)record, (int)ESystemExit.REBOOT.getValue());
        this.sendNotification(env, record);
    }

    private void setNodeStyles(@Nullable CNodeId aOldId, @NotNull CNodeId aCurrentNodeId) throws CException {
        if (aOldId != null) {
            this.getWebApi().removeClassFromElement("#id_node_" + String.valueOf(aOldId), "node_active");
        }
        this.getWebApi().addClassToElement("#id_node_" + String.valueOf(aCurrentNodeId), "node_active");
    }

    private void setLinkStyles(@Nullable UUID aOldId, @NotNull UUID aCurrentLinkId) throws CException {
        if (aOldId != null) {
            this.getWebApi().removeClassFromElement("#id_link_" + String.valueOf(aOldId), "link_active");
        }
        this.getWebApi().addClassToElement("#id_link_" + String.valueOf(aCurrentLinkId), "link_active");
    }

    private void updateDetailsLink(@NotNull CLinkDto aLink, boolean aIncoming, String aLocalAddress, String aRemoteAddress, CNodeAddress aRemoteNodeAddress, UUID aRemoteInstanceId, String aConnectionType, String aConnectionUsage, CTargetAddress aTargetAddress) throws CException {
        CNodeId to;
        CNodeId from;
        this.getWebApi().removeElement(ID_00402_DETAILS_IMPL);
        if (aIncoming) {
            from = aLink.getNode2().getNodeId();
            to = aLink.getNode1().getNodeId();
        } else {
            from = aLink.getNode1().getNodeId();
            to = aLink.getNode2().getNodeId();
        }
        String details = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402_details_link.html");
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{FROM}", (String)from.toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{TO}", (String)to.toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{LOCAL}", (String)aLocalAddress);
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{REMOTE}", (String)aRemoteAddress);
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{REMOTE_INSTANCE_ID}", (String)(aRemoteInstanceId == null ? "" : aRemoteInstanceId.toString()));
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{REMOTE_NODE_ADDRESS}", (String)(aRemoteNodeAddress == null ? "" : aRemoteNodeAddress.toString()));
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{USAGE}", (String)aConnectionUsage);
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{TYPE}", (String)aConnectionType);
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{TARGET_ADDRESS}", (String)(aTargetAddress == null ? "" : aTargetAddress.toString()));
        this.getWebApi().setInnerHtml(ID_00402_DETAILS, details);
    }

    private void updateDetailsNode(@NotNull CNodeInfo aNodeInfo) throws CException {
        this.getWebApi().removeElement(ID_00402_DETAILS_IMPL);
        String details = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402_details_node.html");
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{NODE_ADDRESS}", (String)aNodeInfo.getNodeAddress().toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{NODE_ID}", (String)aNodeInfo.getNodeAddress().getNodeId().toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{VENDOR}", (String)aNodeInfo.getVendor());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{NAME}", (String)aNodeInfo.getName());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{DESCRIPTION}", (String)aNodeInfo.getDescription());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{LICENSE}", (String)Objects.requireNonNull(aNodeInfo.getLicense()).toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{INSTANCEID}", (String)aNodeInfo.getInstanceId().toString());
        details = CUtilString.replaceAllOccurrences((String)details, (String)"{STARTTIME}", (String)aNodeInfo.getStartTime().toString());
        this.getWebApi().setInnerHtml(ID_00402_DETAILS, details);
    }

    private void getNodeInfo(@NotNull CNodeId aNodeId) throws CException {
        CNodeAddress nodeAddress = new CNodeAddress(aNodeId);
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordGetNodeInfo.class, (CNodeAddress)nodeAddress);
        CRecord record = CRecordGetNodeInfo.create();
        CRecordGetNodeInfo.setNode((CRecord)record, (CNodeAddress)nodeAddress);
        this.sendRequest(env, record);
    }

    private void registerIds() throws CException {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (CNodeAddress nodeAddress : this.mNodeAddresses) {
            String nodeName = nodeAddress.getNodeId().toString();
            list.add((CallSite)((Object)(PREFIX_NODE + nodeName)));
        }
        for (CLinkDto link : this.mLinks.values()) {
            list.add((CallSite)((Object)(PREFIX_LINK + String.valueOf(link.getConnectionId()))));
        }
        this.getWebApi().registerWidgets(list.toArray(new String[0]));
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402_main.html");
        this.getWebApi().setInnerHtml(this.getParentWidgetId(), main);
    }

    private void sendGetNodeData() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkGetListOfReachableNodes.class);
        CRecord record = CRecordNetworkGetListOfReachableNodes.create();
        this.sendRequest(env, record);
    }

    private void sendGetLinkData(@NotNull CLinkDto aLink) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordNetworkGetConnection.class, (CNodeAddress)aLink.getNode1());
        CRecord record = CRecordNetworkGetConnection.create();
        CRecordNetworkGetConnection.setConnectionId((CRecord)record, (UUID)aLink.getConnectionId());
        this.sendRequest(env, record);
    }

    private void sendGetLinks() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkGetLinks.class);
        CRecord record = CRecordNetworkGetLinks.create();
        this.sendRequest(env, record);
    }

    private void addCss() throws CException {
        String css = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402.css");
        this.getWebApi().addCss(ID_CSS, css);
    }

    private void addJs() throws CException {
        String js = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402_graph.js");
        String graphData = this.createGraphData();
        js = CUtilString.replaceFirstOccurrence((String)js, (String)"[id_00402_nodes]", (String)graphData);
        this.getWebApi().addScript(ID_SCRIPT1, js, null);
    }

    private void updateJs() throws CException {
        String js = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00402_update.js");
        String graphData = this.createGraphData();
        js = CUtilString.replaceFirstOccurrence((String)js, (String)"[id_00402_nodes]", (String)graphData);
        this.getWebApi().removeScript(ID_SCRIPT3);
        this.getWebApi().addScript(ID_SCRIPT3, js, null);
    }

    @NotNull
    private String createGraphData() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("graphData = {\n");
        sb.append("    nodes: [\n");
        int size = this.mNodeAddresses.size();
        int i = 1;
        for (CNodeAddress nodeAddress : this.mNodeAddresses) {
            String nodeId = nodeAddress.getNodeId().toString();
            sb.append("        { id: '");
            sb.append(nodeId);
            sb.append("', name: \"");
            sb.append(nodeId);
            sb.append("\" }");
            if (i < size) {
                sb.append(", ");
            }
            sb.append("\n");
            ++i;
        }
        sb.append("    ],\n");
        sb.append("    links: [\n");
        size = this.mLinks.size();
        i = 1;
        for (CLinkDto link : this.mLinks.values()) {
            String node1 = link.getNode1().getNodeId().toString();
            String node2 = link.getNode2().getNodeId().toString();
            sb.append("        {source: '");
            sb.append(node1);
            sb.append("', target: '");
            sb.append(node2);
            sb.append("', cid: '");
            sb.append(link.getConnectionId());
            sb.append("'}");
            if (i < size) {
                sb.append(", ");
            }
            sb.append("\n");
            ++i;
        }
        sb.append("    ]\n");
        sb.append("};\n");
        return sb.toString();
    }

    private void openDialogEditConfigFiles() throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("nodeId", this.mCurrentNodeId.valueToString());
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_EDIT_CONFIG_FILES, this.getSessionToken(), ID_00402_MODAL, sp);
    }

    private void openDialogEditPreferences() throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("nodeId", this.mCurrentNodeId.valueToString());
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_EDIT_PREFERENCES, this.getSessionToken(), ID_00402_MODAL, sp);
    }

    protected void clearBeforeDismiss() throws CException {
        this.getWebApi().removeElement(ID_00402_NODE_MANAGER_MAIN);
        this.getWebApi().removeCss(ID_CSS);
        this.getWebApi().removeCss(ID_CSS_NODES);
        this.getWebApi().removeScript(ID_SCRIPT1);
        this.getWebApi().removeScript(ID_SCRIPT2);
        this.getWebApi().removeScript(ID_SCRIPT3);
    }
}

