/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingMenuItem;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingRadioButtonMenuItem
extends CSwingMenuItem {
    private final JRadioButtonMenuItem mComponent = new JRadioButtonMenuItem();

    public CSwingRadioButtonMenuItem(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("buttonGroup", this::applyButtonGroup);
        list.addHandler("selected", this::applySelected);
    }

    private boolean applyButtonGroup(@NotNull String aKey, @Nullable Object aValue) {
        String name;
        if (aValue instanceof String && !(name = (String)aValue).isEmpty()) {
            ButtonGroup buttonGroup = this.getWidgetSet().getOrAddButtonGroup(name);
            buttonGroup.add(this.getComponent());
            return true;
        }
        return false;
    }

    private boolean applySelected(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean selected = (Boolean)aValue;
            this.mComponent.setSelected(selected);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JRadioButtonMenuItem getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.RadioButtonMenuItem.name();
    }
}

