/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import javax.swing.Box;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingBox
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingBox.class);
    private static final CIntegerToStringMap mAxisMap = new CIntegerToStringMap("Axis");
    private Box mComponent;

    CSwingBox(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.createComponent(aAttributes);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("axis", this::applyAxis);
    }

    private boolean applyAxis(@NotNull String aKey, @Nullable Object aValue) {
        return true;
    }

    private void createComponent(@NotNull CJsonObject aAttributes) {
        int axis = 0;
        Object o = aAttributes.getValue("axis");
        if (o instanceof String) {
            axis = mAxisMap.get((String)o, 0);
        }
        this.mComponent = new Box(axis);
    }

    @NotNull
    public Box getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Box.name();
    }

    static {
        mAxisMap.add("X_AXIS", 0);
        mAxisMap.add("Y_AXIS", 1);
        mAxisMap.add("LINE_AXIS", 2);
        mAxisMap.add("PAGE_AXIS", 3);
    }
}

