/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class CUtilIcon {
    public static final int BYTE_MASK = 255;

    private CUtilIcon() {
    }

    @NotNull
    public static ImageIcon changeColor(@NotNull ImageIcon aImage, @NotNull Color aColor) {
        Image image = aImage.getImage();
        BufferedImage origImage = CUtilIcon.toBufferedImage(image);
        int width = origImage.getWidth();
        int height = origImage.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, origImage.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int origColor = origImage.getRGB(x, y);
                int alpha = origColor >> 24 & 0xFF;
                int red = origColor >> 16 & 0xFF;
                int green = origColor >> 8 & 0xFF;
                int blue = origColor & 0xFF;
                if (alpha == 255) {
                    red = aColor.getRed();
                    green = aColor.getGreen();
                    blue = aColor.getBlue();
                }
                newImage.setRGB(x, y, new Color(red, green, blue, alpha).getRGB());
            }
        }
        return new ImageIcon(newImage);
    }

    @NotNull
    public static ImageIcon invert2(@NotNull ImageIcon aImage) {
        Image image = aImage.getImage();
        BufferedImage orig = CUtilIcon.toBufferedImage(image);
        BufferedImage rcImage = new BufferedImage(orig.getWidth(), orig.getHeight(), orig.getType());
        int width = orig.getWidth();
        int height = orig.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int origColor = orig.getRGB(x, y);
                int alpha = origColor >> 24 & 0xFF;
                int newAlpha = 255 - alpha;
                int red = origColor >> 16 & 0xFF;
                int green = origColor >> 8 & 0xFF;
                int blue = origColor & 0xFF;
                rcImage.setRGB(x, y, new Color(red, green, blue, newAlpha).getRGB());
            }
        }
        return new ImageIcon(rcImage);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image aImage) {
        if (aImage instanceof BufferedImage) {
            return (BufferedImage)aImage;
        }
        BufferedImage bufferedImage = new BufferedImage(aImage.getWidth(null), aImage.getHeight(null), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(aImage, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }
}

