/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.properties.CStringProperty;
import de.sillysky.nyssr.util.properties.IReadOnlyStringProperties;
import de.sillysky.nyssr.util.string.builder.CPairListStringBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CStringProperties
implements IReadOnlyStringProperties {
    private final Map<String, String> mMap;
    private boolean mIsDirty;

    public CStringProperties() {
        this.mMap = new HashMap<String, String>();
        this.mIsDirty = false;
    }

    public CStringProperties(@Nullable IReadOnlyStringProperties aValue) {
        if (aValue == null) {
            this.mMap = new HashMap<String, String>();
        } else {
            this.mMap = new HashMap<String, String>(aValue.size() + 10);
            for (String key : aValue.getKeys()) {
                this.mMap.put(key, aValue.get(key, ""));
            }
        }
        this.mIsDirty = false;
    }

    public CStringProperties(@Nullable String aProperties) {
        this.mMap = new HashMap<String, String>();
        if (aProperties != null) {
            String[] split;
            for (String pair : split = aProperties.trim().split(",")) {
                pair = pair.trim();
                String[] split2 = pair.trim().split("=");
                this.mMap.put(split2[0].trim(), split2[1].trim());
            }
        }
        this.mIsDirty = false;
    }

    public CStringProperties(@NotNull Map<String, String> aMap) {
        this.mMap = aMap;
        this.mIsDirty = false;
    }

    @NotNull
    public static CStringProperties fromList(@Nullable List<?> aList) throws CException {
        CStringProperties sps = new CStringProperties();
        if (aList != null) {
            for (Object o : aList) {
                if (!(o instanceof String)) continue;
                CStringProperty sp = new CStringProperty((String)o);
                sps.put(sp);
            }
        }
        sps.resetDirtyFlag();
        return sps;
    }

    @NotNull
    public static CStringProperties fromStream(@NotNull DataInput aStream) throws IOException {
        CStringProperties sps = new CStringProperties();
        int count = CPositiveInteger.fromStream(aStream);
        for (int i = 0; i < count; ++i) {
            CStringProperty sp = CStringProperty.fromStream(aStream);
            sps.put(sp);
        }
        sps.resetDirtyFlag();
        return sps;
    }

    @NotNull
    public static CStringProperties fromStringArrayString(@Nullable String aString) throws CException {
        CStringProperties sps = new CStringProperties();
        if (aString != null) {
            String[] strings;
            for (String s : strings = CUtilStringArray.fromString(aString)) {
                sps.put(s);
            }
        }
        sps.resetDirtyFlag();
        return sps;
    }

    @NotNull
    public static Object random(int aSize) {
        CStringProperties sp = new CStringProperties();
        for (int i = 0; i < aSize; ++i) {
            sp.put(CStringProperty.random());
        }
        return sp;
    }

    @NotNull
    public CStringProperties addAll(@Nullable CStringProperties aProperties) {
        if (aProperties != null) {
            aProperties.mMap.forEach(this::put);
        }
        return this;
    }

    public void addMissing(@NotNull CStringProperties aDefaultProperties) {
        for (String key : aDefaultProperties.getKeys()) {
            String value = this.get(key);
            if (value != null) continue;
            this.put(key, aDefaultProperties.get(key));
        }
    }

    @Override
    public boolean contains(@NotNull CStringProperties aFilter) {
        for (Map.Entry<String, String> e : aFilter.mMap.entrySet()) {
            String v = e.getValue();
            if (v.equals(this.mMap.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void ensure(@NotNull String aKey, @NotNull String aValue) {
        if (this.get(aKey) == null) {
            this.put(aKey, aValue);
        }
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CStringProperties that = (CStringProperties)aO;
        return this.mMap.equals(that.mMap);
    }

    @Override
    public boolean existKey(@NotNull String aKey) {
        return this.mMap.containsKey(aKey);
    }

    @Override
    public String get(@NotNull String aKey) {
        return this.mMap.get(aKey);
    }

    @Override
    public String getNormalized(@NotNull String aKey) {
        return this.mMap.get(CUtilNormalize.normalize(aKey));
    }

    @Override
    public String get(@NotNull String aKey, @Nullable String aDefault) {
        String value = this.get(aKey);
        return value == null ? aDefault : value;
    }

    @Override
    public String getNormalized(@NotNull String aKey, @Nullable String aDefault) {
        String value = this.get(CUtilNormalize.normalize(aKey));
        return value == null ? aDefault : value;
    }

    public String get(@NotNull @NotNull String @NotNull [] aKeys, @Nullable String aDefault) {
        for (String key : aKeys) {
            String v = this.get(key);
            if (!CUtilString.isValid(v)) continue;
            return v;
        }
        return aDefault;
    }

    @Override
    @NotNull
    public CStringProperties getDoubles(@NotNull IReadOnlyStringProperties aCompare, boolean aRemove) {
        CStringProperties doubles = new CStringProperties();
        for (String key : aCompare.getKeys()) {
            String valueCompare;
            String valueWork = this.get(key);
            if (valueWork == null || !CUtilString.equals(valueCompare = aCompare.get(key), valueWork)) continue;
            doubles.put(key, valueWork);
            if (!aRemove) continue;
            this.remove(key);
        }
        return doubles;
    }

    @Override
    @NotNull
    public CStringProperties getExisting(@NotNull IReadOnlyStringProperties aCompare, boolean aValueFromCompare) {
        return this.getExisting(aCompare, false, aValueFromCompare);
    }

    @NotNull
    public CStringProperties getExisting(@NotNull IReadOnlyStringProperties aCompare, boolean aRemove, boolean aValueFromCompare) {
        CStringProperties result = new CStringProperties();
        for (String key : aCompare.getKeys()) {
            if (!this.existKey(key)) continue;
            String value = aValueFromCompare ? aCompare.get(key) : this.get(key);
            result.put(key, value);
            if (!aRemove) continue;
            this.remove(key);
        }
        return result;
    }

    @Override
    @Contract(value=" -> new")
    @NotNull
    public Collection<String> getKeys() {
        return new ArrayList<String>(this.mMap.keySet());
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public CStringProperties copy() {
        return new CStringProperties(this);
    }

    @Override
    public boolean match(@Nullable IReadOnlyStringProperties aProperties) {
        if (aProperties == null || aProperties.isEmpty()) {
            return true;
        }
        boolean match = true;
        for (String key : aProperties.getKeys()) {
            String hisValue = aProperties.get(key);
            String myValue = this.get(key);
            if (Objects.equals(myValue, hisValue)) continue;
            match = false;
            break;
        }
        return match;
    }

    public String remove(@NotNull String aKey) {
        String removed = this.mMap.remove(aKey);
        if (removed != null) {
            this.mIsDirty = true;
        }
        return removed;
    }

    public boolean put(@NotNull CStringProperty aProperty) {
        return this.put(aProperty.getKey(), aProperty.getValue());
    }

    public boolean put(@NotNull String aKeyValue) throws CException {
        CStringProperty sp = new CStringProperty(aKeyValue);
        return this.put(sp);
    }

    public boolean put(@NotNull String aKey, @NotNull String aValue) {
        String oldValue = this.get(aKey);
        if (oldValue == null || !oldValue.equals(aValue)) {
            this.mMap.put(aKey, aValue);
            this.mIsDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public void takeOverIf(@NotNull CStringProperties aAttributes, @NotNull String aName) {
        String s = aAttributes.get(aName);
        if (s != null) {
            this.put(aName, s);
        }
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CPositiveInteger.toStream(aStream, this.size());
        for (Map.Entry<String, String> entry : this.mMap.entrySet()) {
            CStringProperty sp = new CStringProperty(entry.getKey(), entry.getValue());
            sp.toStream(aStream);
        }
    }

    public String toString() {
        CPairListStringBuilder sb = new CPairListStringBuilder();
        this.mMap.entrySet().stream().sorted(sb).forEach(sb::append);
        return sb.toString();
    }

    @Override
    public void valueToList(@NotNull List<String> aList) {
        for (Map.Entry<String, String> entry : this.mMap.entrySet()) {
            CStringProperty sp = new CStringProperty(entry.getKey(), entry.getValue());
            sp.valueToList(aList);
        }
    }

    @Override
    @NotNull
    public String valueToString() {
        ArrayList<String> list = new ArrayList<String>(this.size());
        this.valueToList(list);
        String[] arr = new String[list.size()];
        arr = list.toArray(arr);
        return CUtilStringArray.toStringWithPipe(arr);
    }

    public void resetDirtyFlag() {
        this.mIsDirty = false;
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }
}

