/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.hash.CAbstractHash;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import de.sillysky.nyssr.util.hash.EHashType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CHash
extends CAbstractHash {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHash.class);
    private MessageDigest mMessageDigest = null;

    public CHash() {
        super(EHashType.EMPTY, null, "");
    }

    public CHash(String aAlgorithm, EHashType aType) throws NoSuchAlgorithmException {
        super(aType, null, aAlgorithm);
        if (aType != EHashType.EMPTY) {
            this.ensure();
        }
    }

    public CHash(String aAlgorithm, EHashType aType, byte[] aHash) throws NoSuchAlgorithmException {
        super(aType, aHash, aAlgorithm);
        if (aType != EHashType.EMPTY) {
            this.ensure();
        }
    }

    @NotNull
    public static String getString(byte[] aMd5) {
        return CUtilMd5.getString(aMd5);
    }

    @NotNull
    public static CHash random(int aSize) throws NoSuchAlgorithmException {
        byte[] data = CUtilByteArray.random(aSize);
        CHash hash = new CHash("SHA-384", EHashType.SHA384);
        hash.update(data, 0, data.length);
        hash.digest();
        return hash;
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull CHash @NotNull [] randomArray(int aSize, boolean aWithNullValues) throws NoSuchAlgorithmException {
        CHash[] arr = new CHash[aSize];
        for (int i = 0; i < aSize; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            arr[i] = CHash.random(20);
        }
        return arr;
    }

    @Override
    public void digest() {
        if (this.mMessageDigest != null) {
            this.storeDigest(this.mMessageDigest.digest());
        }
    }

    private void ensure() throws NoSuchAlgorithmException {
        if (this.mMessageDigest == null) {
            this.mMessageDigest = MessageDigest.getInstance(this.getAlgorithm());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getByteArrayWithHeader() {
        int streamedLength = this.getStreamedLength();
        try (ByteArrayOutputStream s = new ByteArrayOutputStream(streamedLength);){
            byte[] byArray;
            try (DataOutputStream d = new DataOutputStream(s);){
                this.toStream(d);
                d.close();
                byArray = s.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            LOG.error("e, Exception on streaming the hash: {}");
            return null;
        }
    }

    @Override
    public int getDigestLength() {
        if (this.mMessageDigest != null) {
            return this.mMessageDigest.getDigestLength();
        }
        return 0;
    }

    @Override
    public void setDigest(byte[] aDigest) {
        if (aDigest == null) {
            LOG.error("IHash({}).setDigest: Can't process a digest of null.", this.getAlgorithm());
            return;
        }
        if (aDigest.length != this.getDigestLength()) {
            LOG.error("IHash({}).setDigest: Can't process a digest length of {}, need {} bytes.", this.getAlgorithm(), aDigest.length, this.getDigestLength());
            return;
        }
        this.storeDigest(aDigest);
    }

    @Override
    public void update(byte[] aData, int aPosition, int aLength) {
        if (this.mMessageDigest != null) {
            this.mMessageDigest.update(aData, aPosition, aLength);
        }
    }

    @Override
    public String valueToString() {
        return this.toString();
    }
}

