/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilString {
    public static final String LINE = CUtilString.create('-', 119);
    public static final String LINE_CRLF = LINE + "\n";
    public static final String CRLF = System.getProperty("line.separator", "\n");
    public static final String SLOT_DELIMITER_STRING = "|";
    static final char SLOT_DELIMITER = '|';
    private static final int PRIM = 1127;
    private static final char SPACE = ' ';
    private static final char BACKSLASH = '\\';
    private static final char CRLF_CHAR = '\n';
    private static final char QUOTE = '\"';
    private static Pattern mPatternCheckNumeric;

    private CUtilString() {
    }

    public static int compareTo(@Nullable String aS1, @Nullable String aS2) {
        if (aS1 == null) {
            if (aS2 == null) {
                return 0;
            }
            return 1;
        }
        if (aS2 == null) {
            return -1;
        }
        return aS1.compareTo(aS2);
    }

    public static int compareToIgnoreCase(@Nullable String aS1, @Nullable String aS2) {
        if (aS1 == null) {
            if (aS2 == null) {
                return 0;
            }
            return 1;
        }
        if (aS2 == null) {
            return -1;
        }
        return aS1.compareToIgnoreCase(aS2);
    }

    @Nullable
    public static String fromStream(@NotNull DataInput aStream) throws IOException {
        byte[] bb = CUtilByteArray.fromStream(aStream);
        return bb == null ? null : new String(bb, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String fromString(@Nullable String aStr) {
        return CUtilString.unescapeSlot(aStr, '|');
    }

    @NotNull
    public static String random(int aLength) {
        char[] temp = new char[aLength];
        for (int i = 0; i < aLength; ++i) {
            temp[i] = (char)(97 + CUtilRandom.getRandom().nextInt(26));
        }
        return new String(temp);
    }

    public static boolean endsWithChar(@NotNull String aString, char aChar) {
        int len = aString.length();
        return aString.charAt(len - 1) == aChar;
    }

    @NotNull
    public static String ensureLastChar(@NotNull String aString, char aMustHave) {
        int len = aString.length();
        if (aString.charAt(len - 1) != aMustHave) {
            return aString + aMustHave;
        }
        return aString;
    }

    @Nullable
    public static Character getLastChar(@Nullable String aString) {
        if (aString == null || aString.isEmpty()) {
            return null;
        }
        return Character.valueOf(aString.charAt(aString.length() - 1));
    }

    public static boolean equals(@Nullable String aStr1, @Nullable String aStr2) {
        if (aStr1 == aStr2) {
            return true;
        }
        if (aStr1 != null) {
            return aStr1.equals(aStr2);
        }
        return false;
    }

    @NotNull
    public static String escapeSlot(@Nullable String aText, char aDelimiter) {
        if (aText == null || aText.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(aText.length() + 10);
        for (int i = 0; i < aText.length(); ++i) {
            char c = aText.charAt(i);
            if (c == aDelimiter) {
                sb.append('\\');
                sb.append(aDelimiter);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static String normalizeText(@NotNull String aText) {
        if (aText.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(aText.length() + 10);
        boolean newLine = false;
        boolean writeSpace = false;
        for (int i = 0; i < aText.length(); ++i) {
            char c = aText.charAt(i);
            if (c == '\"') {
                if (writeSpace && sb.length() > 0) {
                    sb.append(' ');
                }
                writeSpace = false;
                sb.append('\\');
                sb.append('\"');
                continue;
            }
            if (c == '\n') {
                writeSpace = true;
                continue;
            }
            if (c == ' ') {
                writeSpace = true;
                continue;
            }
            if (writeSpace && sb.length() > 0) {
                sb.append(' ');
            }
            writeSpace = false;
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String fromFile(@NotNull String aFileName) {
        String text;
        BufferedReader br = null;
        String cr = System.getProperty("line.separator");
        try {
            String s;
            StringBuilder content = new StringBuilder();
            FileReader fr = new FileReader(aFileName);
            br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                content.append(s).append(cr);
            }
            text = content.toString();
        }
        catch (Exception e) {
            text = "";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return text;
    }

    @NotNull
    public static String getCamelCase(@NotNull String aOrig) {
        StringBuilder sb = new StringBuilder(aOrig.length());
        for (int i = 0; i < aOrig.length(); ++i) {
            char c = aOrig.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (c == '_') {
                c = aOrig.charAt(++i);
                c = Character.toUpperCase(c);
            } else {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static String getShortenString(@Nullable StringBuffer aOriginal, int aMaxLen) {
        int len;
        if (aOriginal != null && aMaxLen > 0 && (len = Math.min(aOriginal.length(), aMaxLen)) > 0) {
            return aOriginal.substring(0, len);
        }
        return "";
    }

    public static String getShortenString(@Nullable StringBuilder aOriginal, int aMaxLen) {
        int len;
        if (aOriginal != null && aMaxLen > 0 && (len = Math.min(aOriginal.length(), aMaxLen)) > 0) {
            return aOriginal.substring(0, len);
        }
        return "";
    }

    public static boolean isBetter(@Nullable String aOldString, @Nullable String aNewString) {
        if (CUtilString.isEmpty(aOldString)) {
            return CUtilString.isValid(aNewString);
        }
        return false;
    }

    public static boolean isEmpty(@Nullable String aText) {
        return aText == null || aText.isEmpty() || "null".equalsIgnoreCase(aText);
    }

    public static boolean isNumeric(@NotNull String aString) {
        if (mPatternCheckNumeric == null) {
            mPatternCheckNumeric = Pattern.compile("[+-]{0,1}\\d+");
        }
        return mPatternCheckNumeric.matcher(aString).matches();
    }

    public static boolean isValid(@Nullable String aText) {
        return !CUtilString.isEmpty(aText);
    }

    @NotNull
    public static String nonEmpty(@Nullable String aCheck, @NotNull String aDefault) {
        if (CUtilString.isEmpty(aCheck)) {
            return aDefault;
        }
        return aCheck;
    }

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public static String notNull(@Nullable String aCheck) {
        if (aCheck == null) {
            return "";
        }
        return aCheck;
    }

    @NotNull
    public static String removeLastChar(@NotNull String aPath, char aLastCharToAvoid) {
        int len = aPath.length();
        if (len > 0 && aPath.charAt(len - 1) == aLastCharToAvoid) {
            return aPath.substring(0, len - 1);
        }
        return aPath;
    }

    @NotNull
    public static String shortenString(@NotNull String aOriginal, int aMaxLen) {
        int len;
        String result = aOriginal;
        if (aMaxLen > 0 && (len = Math.min(aOriginal.length(), aMaxLen)) > 0) {
            result = aOriginal.substring(0, len);
        }
        return result;
    }

    @NotNull
    public static @NotNull String @NotNull [] splitCommaSeparatedList(@NotNull String aText) {
        ArrayList<String> split = new ArrayList<String>();
        int skipCommas = 0;
        boolean backslash = false;
        StringBuilder sb = new StringBuilder(100);
        for (char c : aText.toCharArray()) {
            if (c == '\\') {
                backslash = true;
            }
            if (c == ',' && skipCommas == 0) {
                String str = sb.toString().trim();
                split.add(str);
                sb.setLength(0);
            } else if (!backslash) {
                if (c == '\"') {
                    skipCommas = skipCommas == 0 ? ++skipCommas : --skipCommas;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append('\\');
                sb.append(c);
            }
            if (c == '\\') continue;
            backslash = false;
        }
        if (sb.length() > 0) {
            String str = sb.toString().trim();
            split.add(str);
        }
        int size = split.size();
        String[] arr = new String[size];
        return split.toArray(arr);
    }

    @NotNull
    public static String toStringRecord(short aType, @NotNull String aValue) {
        String key = Short.toString(aType);
        CStringRecord r = new CStringRecord(key, aValue);
        return r.getRecordString();
    }

    @NotNull
    public static String unescapeSlot(@Nullable String aText, char aDelimiter) {
        if (aText == null || aText.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(aText.length() + 10);
        for (int i = 0; i < aText.length(); ++i) {
            char c = aText.charAt(i);
            if (c == '\\') {
                if (i + 1 >= aText.length()) continue;
                char c1 = aText.charAt(i + 1);
                if (c1 == aDelimiter) {
                    sb.append(aDelimiter);
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable String aValue) throws IOException {
        byte[] bb = aValue == null ? null : aValue.getBytes(StandardCharsets.UTF_8);
        CUtilByteArray.toStream(aStream, bb);
    }

    @NotNull
    public static String toString(@Nullable String aStr) {
        return CUtilString.escapeSlot(aStr, '|');
    }

    @Nullable
    public static String fromObject(@Nullable Object aValue, @Nullable String aDefault) {
        if (aValue instanceof String) {
            return (String)aValue;
        }
        if (aValue != null) {
            return aValue.toString();
        }
        return aDefault;
    }

    @NotNull
    public static String create(char aChar, int aLength) {
        CUtilCheck.checkTrue(aLength > 0, "Length must be positive", new Object[0]);
        StringBuilder sb = new StringBuilder(aLength);
        for (int i = 0; i < aLength; ++i) {
            sb.append(aChar);
        }
        return sb.toString();
    }

    public static String replaceAllOccurrences(String aInput, String aToken, String aReplacement) {
        if (aInput == null || aToken == null || aToken.isEmpty()) {
            return aInput;
        }
        return aInput.replace(aToken, aReplacement);
    }

    public static String replaceFirstOccurrence(String aInput, String aToken, String aReplacement) {
        if (aInput == null || aToken == null || aToken.isEmpty()) {
            return aInput;
        }
        int index = aInput.indexOf(aToken);
        if (index == -1) {
            return aInput;
        }
        return aInput.substring(0, index) + aReplacement + aInput.substring(index + aToken.length());
    }

    public static String insertBeforeFirstOccurrence(String aInput, String aToken, String aInsertString) {
        if (aInput == null || aToken == null || aToken.isEmpty()) {
            return aInput;
        }
        int index = aInput.indexOf(aToken);
        if (index == -1) {
            return aInput;
        }
        return aInput.substring(0, index) + aInsertString + aInput.substring(index);
    }

    @NotNull
    public static String removeFirstChar(@NotNull String aKey, char aCharToAvoid) {
        if (aKey.charAt(0) == aCharToAvoid) {
            return aKey.substring(1);
        }
        return aKey;
    }
}

