/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.verifier;

import de.sillysky.nyssr.util.CUtilUuid;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CSessionData {
    private final byte[] mShortToken;
    private final String mUserId;
    private final String[] mRights;
    private ZonedDateTime mTimeStamp;

    public CSessionData(byte[] aShortToken, @NotNull String aUserId, @NotNull String[] aRights, @NotNull ZonedDateTime aTimeStamp) {
        this.mShortToken = aShortToken == null ? CUtilUuid.toByteArray(CUtilUuid.random()) : aShortToken;
        this.mUserId = aUserId;
        this.mRights = aRights;
        this.mTimeStamp = aTimeStamp;
    }

    public byte[] getShortToken() {
        return this.mShortToken;
    }

    @NotNull
    public String getUserId() {
        return this.mUserId;
    }

    @NotNull
    public String[] getRightIds() {
        return this.mRights;
    }

    @NotNull
    public ZonedDateTime getTimeStamp() {
        return this.mTimeStamp;
    }

    public void setTimeStamp(@NotNull ZonedDateTime aTimeStamp) {
        this.mTimeStamp = aTimeStamp;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSessionData that = (CSessionData)aO;
        return Arrays.equals(this.mShortToken, that.mShortToken);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mShortToken);
    }
}

