/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.registry.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordDeregisterTarget;
import de.sillysky.nyssr.target.registry.records.CRecordGetTargetInfo;
import de.sillysky.nyssr.target.registry.records.CRecordRegisterTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class CTargetForTargetRegistry
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTargetRegistry.class);
    private INameDb mNameDb;
    private INamespaceRegistry mNamespaceRegistry;

    CTargetForTargetRegistry() {
        LOG.debug("Activate {} {}", this.getClass().getSimpleName(), System.identityHashCode(this));
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRegisterTarget.ID, this::asyncRegisterTarget);
        this.addMessageHandler(CRecordDeregisterTarget.ID, this::asyncDeregisterTarget);
        this.addMessageHandler(CRecordGetTargetInfo.ID, this::asyncGetTargetInfo);
    }

    public static void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
        aDependencyList.add(INamespaceRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNameDb = aServiceRegistry.getService(INameDb.class);
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        ITargetRegistry targetRegistry = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (targetRegistry != null);
        targetRegistry.registerTarget(this, CWellKnownTID.TARGET_REGISTRY);
    }

    private boolean asyncDeregisterTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId nid = CRecordDeregisterTarget.getNamespaceId(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId tid = CRecordDeregisterTarget.getTargetId(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Target ID", new Object[0]);
        namespace.getTargetRegistry().deregisterTarget(tid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetTargetInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IId[] tidArray;
        IId nid = CRecordGetTargetInfo.getNamespaceId(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        HashSet<IId> requestList = new HashSet<IId>();
        IId tid = CRecordGetTargetInfo.getTid(aRecord, null);
        if (tid != null) {
            requestList.add(tid);
        }
        if ((tidArray = CRecordGetTargetInfo.getTids(aRecord, null)) != null) {
            Collections.addAll(requestList, tidArray);
        }
        boolean all = CRecordGetTargetInfo.getAllTargets(aRecord, false);
        CRecord[] result = namespace.getTargetRegistry().getTargetInfo(all, requestList);
        CRecordGetTargetInfo.setTargets(aRecord, result);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IId nid = CRecordRegisterTarget.getNamespaceId(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        Object obj = CRecordRegisterTarget.getTarget(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Target object", new Object[0]);
        if (!(obj instanceof ITarget)) {
            throw new CException(7).append("Object is not instance of ITarget.");
        }
        ITarget tgt = (ITarget)obj;
        IId tid = CRecordRegisterTarget.getTidWanted(aRecord, null);
        namespace.getTargetRegistry().registerTarget(tgt, tid);
        CTargetAddress address = tgt.getAddress();
        CRecordRegisterTarget.setAddress(aRecord, address);
        String name = CRecordRegisterTarget.getName(aRecord, null);
        if (name != null) {
            this.mNameDb.getTargetAddressDatabase().putName(address, name);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

