/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.CService;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.service.IServiceListener;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class CServiceRegistryListenerList {
    private final IServiceRegistry mServiceRegistry;
    private final String mEventType;
    private final Map<String, List<IServiceListener>> mListener;

    CServiceRegistryListenerList(@NotNull IServiceRegistry aServiceRegistry, @NotNull String aEventType) {
        this.mServiceRegistry = aServiceRegistry;
        this.mEventType = aEventType;
        this.mListener = new ConcurrentHashMap<String, List<IServiceListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        Map<String, List<IServiceListener>> map = this.mListener;
        synchronized (map) {
            String name = aClass.getName();
            List listeners = this.mListener.computeIfAbsent(name, k -> new ArrayList());
            listeners.add(aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        Map<String, List<IServiceListener>> map = this.mListener;
        synchronized (map) {
            List<IServiceListener> listeners = this.mListener.get(aClass.getName());
            if (listeners != null) {
                listeners.remove(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListener(@NotNull CService aService) {
        String name = aService.getService().getName();
        ArrayList<IServiceListener> list = new ArrayList<IServiceListener>();
        Map<String, List<IServiceListener>> map = this.mListener;
        synchronized (map) {
            List<IServiceListener> listeners = this.mListener.get(name);
            if (listeners != null) {
                list.addAll(listeners);
            }
        }
        for (IServiceListener l : list) {
            try {
                l.notifyServiceEvent(this.mServiceRegistry, this.mEventType, aService.getService(), aService.getInstance(), aService.getProperties());
            }
            catch (Exception e) {
                CServiceRegistry.LOG.error((Throwable)e, "Error notifying listener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, List<IServiceListener>> map = this.mListener;
        synchronized (map) {
            this.mListener.clear();
        }
    }
}

