/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.hook;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.message.hook.CAsyncMessageHook;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.hook.EMessageHookCause;
import de.sillysky.nyssr.message.hook.IMessageHook;
import de.sillysky.nyssr.message.hook.IMessageHookRegistry;
import de.sillysky.nyssr.message.hook.IPrivateMessageHookRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

final class CMessageHookRegistry
implements IMessageHookRegistry,
IPrivateMessageHookRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMessageHookRegistry.class);
    private final Map<CTargetAddress, CAsyncMessageHook> mAsyncHooks = new HashMap<CTargetAddress, CAsyncMessageHook>(10);
    private final Set<IMessageHook> mHooks = new CopyOnWriteArraySet<IMessageHook>();
    private IMessageSender mSender = null;
    private CTargetAddress mMyAddress;

    CMessageHookRegistry() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IMessageHookRegistry.class, this);
        aServiceRegistry.registerService(IPrivateMessageHookRegistry.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(CTargetAddress aObserver, CTargetAddress[] aReceiverFilter) {
        Map<CTargetAddress, CAsyncMessageHook> map = this.mAsyncHooks;
        synchronized (map) {
            CAsyncMessageHook hook = this.mAsyncHooks.get(aObserver);
            if (hook == null) {
                hook = new CAsyncMessageHook(this, aObserver, aReceiverFilter);
                this.mAsyncHooks.put(aObserver, hook);
                this.registerMessageHook(hook);
                LOG.info("Message Logger {} added.", aObserver);
            } else {
                hook.setFilterList(aReceiverFilter);
                LOG.info("Message Logger changed to {}.", Arrays.toString(aReceiverFilter));
            }
        }
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void deregisterMessageHook(@NotNull IMessageHook aHook) {
        LOG.debug("Remove Hook {}.", aHook);
        this.mHooks.remove(aHook);
    }

    @Override
    public void initialize(IMessageSender aSender) {
        this.mSender = aSender;
        CNodeAddress nodeAddress = this.mSender.getNodeAddress();
        this.mMyAddress = new CTargetAddress(CWellKnownTID.MSG_HOOK_REGISTRY, CWellKnownNID.SYSTEM, nodeAddress.getNodeId(), nodeAddress.getSegmentId());
    }

    @Override
    public CMessage invokeMessageHook(@NotNull CMessage aMsg, EMessageHookCause aCause) {
        if (this.mHooks.size() == 0) {
            return aMsg;
        }
        CMessage localMsg = aMsg;
        Iterator<IMessageHook> it = this.mHooks.iterator();
        while (localMsg != null && it.hasNext()) {
            IMessageHook hook = it.next();
            Iterator<CTargetAddress> itFilter = hook.getFilter();
            CEnvelope envelope = localMsg.getEnvelope();
            if (!this.match(envelope.getSender(), envelope.getReceiver(), itFilter)) continue;
            try {
                localMsg = hook.hook(localMsg, aCause);
            }
            catch (Exception e) {
                LOG.error(e, "Hook: Error on invoking message hook: MSG={} {}", aMsg);
            }
        }
        return localMsg;
    }

    private boolean match(IId aFilter, IId aIdFromMsg) {
        if (!CIdFactory.isValid(aFilter)) {
            return true;
        }
        return aFilter.equals(aIdFromMsg);
    }

    private boolean match(CNodeId aFilter, CNodeId aIdFromMsg) {
        if (CNodeId.isEmpty(aFilter)) {
            return true;
        }
        return aFilter.equals(aIdFromMsg);
    }

    private boolean match(CTargetAddress aFilter, CTargetAddress aFromMsg) {
        if (aFromMsg == null) {
            return false;
        }
        if (!this.match(aFilter.getTID(), aFromMsg.getTID())) {
            return false;
        }
        if (!this.match(aFilter.getNID(), aFromMsg.getNID())) {
            return false;
        }
        return this.match(aFilter.getNodeId(), aFromMsg.getNodeId());
    }

    private boolean match(CTargetAddress aSender, CTargetAddress aReceiver, Iterator<CTargetAddress> aIterator) {
        if (aIterator == null || !aIterator.hasNext()) {
            return true;
        }
        while (aIterator.hasNext()) {
            CTargetAddress ta = aIterator.next();
            if (this.match(ta, aSender)) {
                return true;
            }
            if (!this.match(ta, aReceiver)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNamespaceDeregistered(IId aNID) {
        Map<CTargetAddress, CAsyncMessageHook> map = this.mAsyncHooks;
        synchronized (map) {
            ArrayList<CTargetAddress> list = new ArrayList<CTargetAddress>();
            for (CTargetAddress a : this.mAsyncHooks.keySet()) {
                if (!a.getNID().equals(aNID)) continue;
                list.add(a);
            }
            for (CTargetAddress a : list) {
                this.removeObserver(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRemoteNodeRemoved(CNodeAddress aNodeAddress) {
        Map<CTargetAddress, CAsyncMessageHook> map = this.mAsyncHooks;
        synchronized (map) {
            ArrayList<CTargetAddress> list = new ArrayList<CTargetAddress>();
            for (CTargetAddress a : this.mAsyncHooks.keySet()) {
                if (!a.getNodeAddress().equals(aNodeAddress)) continue;
                list.add(a);
            }
            for (CTargetAddress a : list) {
                this.removeObserver(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTargetDeregistered(CTargetAddress aAddress) {
        Map<CTargetAddress, CAsyncMessageHook> map = this.mAsyncHooks;
        synchronized (map) {
            this.removeObserver(aAddress);
        }
    }

    @Override
    public void registerMessageHook(@NotNull IMessageHook aHook) {
        LOG.debug("Add Hook {}.", aHook);
        this.mHooks.add(aHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(CTargetAddress aObserver) {
        Map<CTargetAddress, CAsyncMessageHook> map = this.mAsyncHooks;
        synchronized (map) {
            CAsyncMessageHook hook;
            CAsyncMessageHook messageHook = this.mAsyncHooks.get(aObserver);
            if (messageHook != null && (hook = this.mAsyncHooks.remove(aObserver)) != null) {
                this.deregisterMessageHook(hook);
                LOG.info("Message Logger {} removed.", aObserver);
            }
        }
    }

    void sendNotification(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        if (this.mSender != null) {
            aEnvelope.setSender(this.mMyAddress);
            this.mSender.sendNotification(aEnvelope, aRecord);
        }
    }
}

