/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.handler.registry;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.handler.registry.IMessageHandler;
import de.sillysky.nyssr.message.handler.registry.IMessageHandlerRegistry;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.message.logger.IMessageLoggerFactory;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMessageHandlerRegistry
implements IMessageHandlerRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMessageHandlerRegistry.class);
    private final Map<IId, LinkedList<IMessageHandler>> mHandlerMap;
    private final Object mOwnerOrLogger;
    private IMessageHandler mNullMessageHandler = null;
    private boolean mVerbose = true;
    @Nullable
    private IMessageLogger mMessageLogger;

    CMessageHandlerRegistry(Object aOwnerOrLogger) {
        this.mOwnerOrLogger = aOwnerOrLogger;
        this.mHandlerMap = new HashMap<IId, LinkedList<IMessageHandler>>();
    }

    @Override
    public final void addMessageHandler(IId aId, @NotNull IMessageHandler aHandler) {
        if (aId == null || !aId.isValid()) {
            this.mNullMessageHandler = aHandler;
        } else {
            LinkedList<IMessageHandler> handler1 = this.mHandlerMap.get(aId);
            if (handler1 == null) {
                handler1 = new LinkedList();
                this.mHandlerMap.put(aId, handler1);
            }
            handler1.addFirst(aHandler);
        }
    }

    @Nullable
    private IMessageLogger createMessageLogger() {
        CServiceRegistry sr;
        IMessageLoggerFactory factory;
        if (this.mMessageLogger == null && (factory = (sr = CServiceRegistry.getInstance()).getService(IMessageLoggerFactory.class)) != null) {
            this.mMessageLogger = factory.createLogger(this.mOwnerOrLogger);
        }
        return this.mMessageLogger;
    }

    @Override
    public final void handleMessage(@NotNull CMessage aMsg) {
        String handlerString;
        CEnvelope env;
        boolean handled;
        IMessageLogger ml;
        block8: {
            List handler;
            boolean verbose;
            CRecord record;
            block6: {
                block7: {
                    ml = this.createMessageLogger();
                    handled = false;
                    env = aMsg.getEnvelope();
                    record = aMsg.getRecord();
                    handlerString = "?";
                    verbose = this.isVerbose(env);
                    IId id = record.getId();
                    handler = this.mHandlerMap.get(id);
                    if (handler != null) break block6;
                    if (this.mNullMessageHandler == null) break block7;
                    handled = this.internalHandleMessage(this.mNullMessageHandler, env, record, verbose);
                    break block8;
                }
                if (!verbose || ml == null) break block8;
                String string1 = ml.logNotHandled(this.mOwnerOrLogger, env, record);
                String string2 = ml.logMessage(env, record);
                ml.getLogger().trace("{} ------> {}", string1, string2);
                break block8;
            }
            for (IMessageHandler h : handler) {
                handlerString = h.toString();
                handled |= this.internalHandleMessage(h, env, record, verbose);
            }
        }
        if (handled) {
            env.setHandled(true);
        } else {
            env.setResult(2001, "Not handled.");
        }
        int resultCode = env.getResultCode();
        if (resultCode != 0 && ml != null) {
            if (resultCode == 2001) {
                ml.getLogger().warn("Message not handled: {}", aMsg.toString());
            } else {
                ml.getLogger().error("ResultCode={} ResultText={} MsgInstance={} Handler={}", resultCode, env.getResultText(), env.getInstanceId(), handlerString);
            }
        }
    }

    private boolean internalHandleMessage(IMessageHandler aHandler, CEnvelope aEnvelope, CRecord aRecord, boolean aVerbose) {
        String message;
        boolean handled;
        String string1;
        if (aVerbose && this.mMessageLogger != null) {
            string1 = this.mMessageLogger.logBefore(this.mOwnerOrLogger, "---", aEnvelope, aRecord);
            String string2 = this.mMessageLogger.logMessage(aEnvelope, aRecord);
            this.mMessageLogger.getLogger().trace("{} ------> {}", string1, string2);
        }
        try {
            handled = aHandler.handleMessage(aEnvelope, aRecord);
        }
        catch (CException e) {
            message = e.getMessage();
            LOG.error(e, "Exception: {}", message);
            handled = true;
            aEnvelope.setResult(e.getCode(), message);
        }
        catch (Exception e) {
            message = e.getMessage();
            LOG.error(e, "Exception: {}", message);
            handled = true;
            aEnvelope.setResult(2, message);
        }
        if (aVerbose && this.mMessageLogger != null) {
            string1 = this.mMessageLogger.logAfter(aEnvelope, aRecord, handled);
            this.mMessageLogger.getLogger().trace(string1);
        }
        return handled;
    }

    @Override
    public final boolean isVerbose() {
        return this.mVerbose;
    }

    private boolean isVerbose(CEnvelope aEnvelope) {
        boolean v1;
        if (this.mVerbose && (v1 = aEnvelope.isLogEnabled()) && this.mMessageLogger != null) {
            boolean v2 = this.mMessageLogger.isTraceEnabled();
            return v2;
        }
        return false;
    }

    @Override
    public final void removeMessageHandler(@NotNull IId aMID) {
        this.mHandlerMap.remove(aMID);
    }

    @Override
    public void removeMessageHandler(@NotNull IId aMID, @NotNull IMessageHandler aHandler) {
        List hh = this.mHandlerMap.get(aMID);
        if (hh != null) {
            hh.remove(aHandler);
        }
    }

    @Override
    public void setMessageLogger(@NotNull IMessageLogger aMessageLogger) {
        this.mMessageLogger = aMessageLogger;
    }

    @Override
    public final void setVerbose(boolean aVerbose) {
        this.mVerbose = aVerbose;
    }
}

