/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.preferences.manager;

import de.sillysky.nyssr.impl.kernel.config.preferences.manager.CPreferenceManager;
import de.sillysky.nyssr.impl.kernel.config.preferences.manager.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplKernelConfigPreferencesManager
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=SYSTEM";
    private IService mService;
    private INamespace mSystemNamespace;
    private IKernelConfiguration mKernelConfiguration;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespace.class, FILTER);
        aDependencyList.add(IKernelConfiguration.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mSystemNamespace = aServiceRegistry.getServiceOrThrow(INamespace.class, FILTER);
            this.mKernelConfiguration = aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mService = new CPreferenceManager(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INamespace getSystemNamespace() {
        return this.mSystemNamespace;
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }
}

