/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config;

import de.sillysky.nyssr.impl.kernel.config.CConfigurationEntry;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CConfigurationEntryList {
    private Map<String, CConfigurationEntry> mMap = new HashMap<String, CConfigurationEntry>(50);

    CConfigurationEntryList() {
    }

    void add(@NotNull CConfigurationEntry aEntry) {
        String pathKey = aEntry.getPathKey();
        CConfigurationEntry old = this.mMap.get(pathKey);
        if (old != null) {
            old.setValue(aEntry.getSource(), aEntry.getValue());
        } else {
            this.mMap.put(pathKey, aEntry);
        }
    }

    List<CConfigurationEntry> getEntries(@NotNull String aPath) {
        ArrayList<CConfigurationEntry> list = new ArrayList<CConfigurationEntry>();
        for (CConfigurationEntry entry : this.mMap.values()) {
            if (!entry.getPath().equalsIgnoreCase(aPath)) continue;
            list.add(entry);
        }
        return list;
    }

    CConfigurationEntry get(@NotNull String aPath, @NotNull String aKey) {
        String path = CUtilString.ensureLastChar(aPath, '/');
        return this.mMap.get(path + aKey);
    }

    CConfigurationEntry get(@NotNull String aPathKey) {
        return this.mMap.get(aPathKey);
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }
}

