/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.job;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.job.CJobEngine;
import de.sillysky.nyssr.impl.job.ILocalDependencies;
import de.sillysky.nyssr.job.IJobEngine;
import de.sillysky.nyssr.job.IJobEngineFactory;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CJobEngineFactory
implements IJobEngineFactory,
IService,
ILocalDependencies {
    private final List<IJobEngine> mEngines = new ArrayList<IJobEngine>();
    private INamespaceFactory mNamespaceFactory;

    @Override
    @NotNull
    public IJobEngine createEngine(@NotNull String aName) throws CException {
        CJobEngine e = new CJobEngine(this, aName);
        this.mEngines.add(e);
        return e;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mNamespaceFactory = aServiceRegistry.getService(INamespaceFactory.class);
        aServiceRegistry.registerService(IJobEngineFactory.class, this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService(this);
        for (IJobEngine e : this.mEngines) {
            e.dismiss();
        }
        this.mEngines.clear();
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }
}

