/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.database;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryFileInfo;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFileEntry {
    @NotNull
    private final String mRelativePath;
    private final long mFileLength;
    @NotNull
    private final FileTime mTimeOfCreation;
    @NotNull
    private final FileTime mTimeOfLastModification;
    @NotNull
    private final String mHash;
    private byte[] mBytes;
    private File mFile;
    private boolean mRegistered = false;

    public CFileEntry(@NotNull String aHash, @NotNull String aRelativePath, @Nullable File aFile, long aFileLength, @NotNull FileTime aTimeOfCreation, @NotNull FileTime aTimeOfLastModification) {
        this.mHash = aHash;
        this.mRelativePath = CUtilPath.normalizeSlashesInPath((String)aRelativePath);
        this.mFileLength = aFileLength;
        this.mTimeOfCreation = aTimeOfCreation;
        this.mTimeOfLastModification = aTimeOfLastModification;
        this.mFile = aFile;
        this.mBytes = null;
    }

    @NotNull
    public String getRelativePath() {
        return this.mRelativePath;
    }

    @Nullable
    public File getFile() {
        return this.mFile;
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CFileEntry fileEntry = (CFileEntry)aObject;
        if (!this.mRelativePath.equals(fileEntry.mRelativePath)) {
            return false;
        }
        return Objects.equals(this.mHash, fileEntry.mHash);
    }

    public int hashCode() {
        int result = this.mRelativePath.hashCode();
        result = 31 * result + this.mHash.hashCode();
        return result;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    @NotNull
    public String getHash() {
        return this.mHash;
    }

    @NotNull
    public FileTime getTimeOfCreation() {
        return this.mTimeOfCreation;
    }

    @NotNull
    public FileTime getTimeOfLastModification() {
        return this.mTimeOfLastModification;
    }

    @NotNull
    public CRecord toRecord() throws CException {
        return CUtilFileStore.fileToRecord(this.mHash, this.mRelativePath, this.mFileLength, this.mTimeOfCreation.toInstant(), this.mTimeOfLastModification.toInstant());
    }

    @NotNull
    public CRecord toRecord(@NotNull CRecord aRecord) throws CException {
        return CUtilFileStore.fileToRecord(aRecord, this.mHash, this.mRelativePath, this.mFileLength, this.mTimeOfCreation.toInstant(), this.mTimeOfLastModification.toInstant());
    }

    public void setFile(@Nullable File aFile) {
        this.mFile = aFile;
    }

    @NotNull
    public static CFileEntry fromRecord(@NotNull CRecord aRecord) {
        String path = CRecordFileStoreFile.getPath((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)path, (String)"path is empty", (Object[])new Object[0]);
        String hash = CRecordFileStoreFile.getHash((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)hash, (String)"hash is empty", (Object[])new Object[0]);
        long fileLength = CRecordFileStoreFile.getFileLength((CRecord)aRecord, (long)0L);
        Instant creationTime = CRecordFileStoreFile.getTimeOfCreation((CRecord)aRecord, (Instant)Instant.now());
        Instant modifiedTime = CRecordFileStoreFile.getTimeOfLastModification((CRecord)aRecord, (Instant)Instant.now());
        return new CFileEntry(hash, path, null, fileLength, FileTime.from(creationTime), FileTime.from(modifiedTime));
    }

    public boolean isRegistered() {
        return this.mRegistered;
    }

    public void setRegistered(boolean aRegistered) {
        this.mRegistered = aRegistered;
    }

    public CRecord toFileInfoRecord(@NotNull CTargetAddress aAddress) throws CException {
        CRecord record = CRecordFileRegistryFileInfo.create();
        CRecordFileRegistryFileInfo.setPath((CRecord)record, (String)this.mRelativePath);
        CRecordFileRegistryFileInfo.setHash((CRecord)record, (String)this.mHash);
        CRecordFileRegistryFileInfo.setTimeOfLastModification((CRecord)record, (Instant)this.mTimeOfLastModification.toInstant());
        CRecordFileRegistryFileInfo.setSourceAddress((CRecord)record, (CTargetAddress)aAddress);
        return record;
    }

    public void setBytes(byte[] aBytes) {
        this.mBytes = aBytes;
    }

    public String toString() {
        return "[path=" + this.mRelativePath + ",hash=" + this.mHash + ",length=" + this.mFileLength + ",created=" + String.valueOf(this.mTimeOfCreation) + ",modified=" + String.valueOf(this.mTimeOfLastModification) + "]";
    }

    public byte[] getChunkFromMemory(long aPos, int aLength) {
        if (this.mBytes != null && aPos + (long)aLength <= (long)this.mBytes.length) {
            return Arrays.copyOfRange(this.mBytes, (int)aPos, (int)(aPos + (long)aLength));
        }
        return null;
    }
}

