/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventLineBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.swing.border.CBubbleBorder;
import de.sillysky.nyssr.util.swing.border.EPointerPosition;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventBubbleBorder
implements IBorder,
IRemoteSkinEvent {
    private static final String COLOR = "color";
    private static final String THICKNESS = "thickness";
    private static final String RADIUS = "radius";
    private static final String POINTER_SIZE = "pointerSize";
    private static final String POINTER_POSITION = "pointerPosition";
    private static final int DEFAULT_RADIUS = -1;
    private static final int DEFAULT_THICKNESS = -1;
    private static final int DEFAULT_POINTER_SIZE = -1;
    private EPointerPosition mPointerPosition;
    private CEventColor mLineColor = null;
    private int mRadius;
    private int mPointerSize;
    private int mThickness;

    @Nullable
    public static CEventBubbleBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CEventColor color;
            CJsonObject jo = (CJsonObject)aValue;
            CEventBubbleBorder event = new CEventBubbleBorder();
            Object o = jo.getValue(COLOR);
            if (o != null && (color = CEventColor.create(o)) != null) {
                event.setLineColor(color);
            }
            event.setThickness(CUtilJsonInteger.fromJson((CJsonObject)jo, (String)THICKNESS, (int)-1));
            event.setRadius(CUtilJsonInteger.fromJson((CJsonObject)jo, (String)RADIUS, (int)-1));
            event.setPointerSize(CUtilJsonInteger.fromJson((CJsonObject)jo, (String)POINTER_SIZE, (int)-1));
            o = jo.getValue(POINTER_POSITION);
            if (o instanceof String) {
                event.setPointerPosition((EPointerPosition)CUtilEnum.fromString(EPointerPosition.class, (String)((String)o), null));
            }
            return event;
        }
        return null;
    }

    public EPointerPosition getPointerPosition() {
        return this.mPointerPosition;
    }

    public void setPointerPosition(@NotNull EPointerPosition aPointerPosition) {
        this.mPointerPosition = aPointerPosition;
    }

    public CEventColor getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(@NotNull CEventColor aLineColor) {
        this.mLineColor = aLineColor;
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(int aRadius) {
        this.mRadius = aRadius;
    }

    public int getPointerSize() {
        return this.mPointerSize;
    }

    public void setPointerSize(int aPointerSize) {
        this.mPointerSize = aPointerSize;
    }

    public int getThickness() {
        return this.mThickness;
    }

    public void setThickness(int aThickness) {
        this.mThickness = aThickness;
    }

    @Override
    public Border createBorder() {
        CBubbleBorder border = new CBubbleBorder();
        if (this.mLineColor != null) {
            border.setLineColor(this.mLineColor.createColor());
        }
        if (this.mPointerPosition != null) {
            border.setPointerPosition(this.mPointerPosition);
        }
        if (this.mRadius >= 0) {
            border.setRadius(this.mRadius);
        }
        if (this.mThickness >= 0) {
            border.setThickness(this.mThickness);
        }
        if (this.mPointerSize >= 0) {
            border.setPointerSize(this.mPointerSize);
        }
        return border;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(CEventLineBorder.EKeys.border_type.name(), (Object)EBorderType.bubble.name());
        if (this.mThickness >= 0) {
            jo.put(THICKNESS, (Object)this.mThickness);
        }
        if (this.mLineColor != null) {
            jo.put(COLOR, this.mLineColor.toJson());
        }
        if (this.mRadius >= 0) {
            jo.put(RADIUS, (Object)this.mRadius);
        }
        if (this.mPointerSize >= 0) {
            jo.put(POINTER_SIZE, (Object)this.mPointerSize);
        }
        if (this.mPointerPosition != null) {
            jo.put(POINTER_POSITION, (Object)this.mPointerPosition);
        }
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.bubble;
    }
}

