/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventRectangle
implements IRemoteSkinEvent {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private final int mX;
    private final int mY;
    private final int mWidth;
    private final int mHeight;

    public CEventRectangle(@NotNull Rectangle aRectangle) {
        this.mX = aRectangle.x;
        this.mY = aRectangle.y;
        this.mWidth = aRectangle.width;
        this.mHeight = aRectangle.height;
    }

    public CEventRectangle(int aX, int aY, int aWidth, int aHeight) {
        this.mX = aX;
        this.mY = aY;
        this.mWidth = aWidth;
        this.mHeight = aHeight;
    }

    @Nullable
    public static CEventRectangle create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int x = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)X, (int)0);
            int y = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)Y, (int)0);
            int width = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)WIDTH, (int)0);
            int height = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)HEIGHT, (int)0);
            return new CEventRectangle(x, y, width, height);
        }
        return null;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.mX, this.mY, this.mWidth, this.mHeight);
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(X, (Object)this.mX);
        jo.put(Y, (Object)this.mY);
        jo.put(WIDTH, (Object)this.mWidth);
        jo.put(HEIGHT, (Object)this.mHeight);
        return jo;
    }
}

