/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.swing.color.CNamedColor;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import de.sillysky.nyssr.util.swing.color.CUtilColor;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventColor
implements IRemoteSkinEvent {
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String ALPHA = "alpha";
    private static final String NAME = "name";
    private final int[] mRgba = new int[4];

    public CEventColor(@NotNull Color aColor) {
        this.mRgba[0] = aColor.getRed();
        this.mRgba[1] = aColor.getGreen();
        this.mRgba[2] = aColor.getBlue();
        this.mRgba[3] = aColor.getAlpha();
    }

    public CEventColor(int[] aRgba) {
        this.mRgba[0] = aRgba[0];
        this.mRgba[1] = aRgba[1];
        this.mRgba[2] = aRgba[2];
        this.mRgba[3] = aRgba[3];
    }

    public CEventColor(int aRed, int aGreen, int aBlue, int aAlpha) {
        this.mRgba[0] = aRed;
        this.mRgba[1] = aGreen;
        this.mRgba[2] = aBlue;
        this.mRgba[3] = aAlpha;
    }

    public CEventColor(@NotNull String aName, int aAlpha) {
        this.mRgba[3] = aAlpha;
        String[] split = aName.split(",");
        if (split[0].startsWith("#")) {
            int[] rgb = CUtilColor.fromHexAsArray((String)split[0]);
            this.mRgba[0] = rgb[0];
            this.mRgba[1] = rgb[1];
            this.mRgba[2] = rgb[2];
        } else {
            CNamedColor namedColor = CNamedColors.get((String)aName);
            if (namedColor != null) {
                int[] rgb = namedColor.getRGB();
                this.mRgba[0] = rgb[0];
                this.mRgba[1] = rgb[1];
                this.mRgba[2] = rgb[2];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static CEventColor create(@Nullable Object aValue) {
        String s;
        int[] rgba;
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            List children = arr.getChildren();
            if (children.size() != 4) return null;
            int red = CUtilInteger.fromObject(children.get(0), (int)0);
            int green = CUtilInteger.fromObject(children.get(1), (int)0);
            int blue = CUtilInteger.fromObject(children.get(2), (int)0);
            int alpha = CUtilInteger.fromObject(children.get(3), (int)255);
            return new CEventColor(red, green, blue, alpha);
        }
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String name = CUtilJsonString.fromJson((CJsonObject)jo, (String)NAME, null);
            if (name != null) {
                int[] rgba2 = CEventColor.parseString(name);
                if (rgba2 == null) return null;
                return new CEventColor(rgba2);
            }
            int red = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)RED, (int)0);
            int green = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)GREEN, (int)0);
            int blue = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)BLUE, (int)0);
            int alpha = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)ALPHA, (int)255);
            return new CEventColor(red, green, blue, alpha);
        }
        if (!(aValue instanceof String) || (rgba = CEventColor.parseString(s = (String)aValue)) == null) return null;
        return new CEventColor(rgba);
    }

    private static int[] parseString(String aS) {
        int[] rgba = new int[4];
        rgba[3] = 255;
        String[] split = aS.split(",");
        if (split.length >= 2) {
            rgba[3] = CUtilInteger.fromObject((Object)split[1], (int)255);
        }
        if (split.length >= 1) {
            if (split[0].startsWith("#")) {
                int[] rgb = CUtilColor.fromHexAsArray((String)split[0]);
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                return rgba;
            }
            CNamedColor namedColor = CNamedColors.get((String)split[0]);
            if (namedColor != null) {
                int[] rgb = namedColor.getRGB();
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                return rgba;
            }
        }
        return null;
    }

    public Color createColor() {
        return new Color(this.mRgba[0], this.mRgba[1], this.mRgba[2], this.mRgba[3]);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray arr = new CJsonArray();
        arr.add((Object)this.mRgba[0]);
        arr.add((Object)this.mRgba[1]);
        arr.add((Object)this.mRgba[2]);
        arr.add((Object)this.mRgba[3]);
        return arr;
    }
}

