/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumnModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRow;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeaderEntry;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableItem;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.enums.ETableAutoResize;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventDimension;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventSetRowHeight;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableColumn;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableColumns;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeader;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeaders;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingTable
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTable.class);
    private final CTable mComponent;

    public CSwingTable(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aProperties) {
        super(aWidgetSet, aId);
        CAttributeHandlerList ahl = this.getAttributeHandlerList();
        ahl.addHandler("background", this::applyTableCellDefaultBackground);
        ahl.addHandler("cells", this::applyCells);
        ahl.addHandler("clear", this::applyClear);
        ahl.addHandler("columns", this::applyColumns);
        ahl.addHandler("alterTableColumn", this::applyAlterColumn);
        ahl.addHandler("addTableColumn", this::applyAddColumn);
        ahl.addHandler("finish", this::applyFinish);
        ahl.addHandler("font", this::applyTableCellDefaultFont);
        ahl.addHandler("foreground", this::applyTableCellDefaultForeground);
        ahl.addHandler("hasTableHeader", this::applyHasHeader);
        ahl.addHandler("pack", this::applyPack);
        ahl.addHandler("resetCells", this::applyResetCells);
        ahl.addHandler("rowHeight", this::applyRowHeight);
        ahl.addHandler("selectionBackground", this::applySelectionBackground);
        ahl.addHandler("selectionForeground", this::applySelectionForeground);
        ahl.addHandler("sizeColumnWidthToFit", this::applySizeColumnWidthToFit);
        ahl.addHandler("sortable", this::applySortable);
        ahl.addHandler("tableAutoResize", this::applyAutoResize);
        ahl.addHandler("tableCell", this::applyTableCell);
        ahl.addHandler("tableCellDefaultBackground", this::applyTableCellDefaultBackground);
        ahl.addHandler("tableCellDefaultForeground", this::applyTableCellDefaultForeground);
        ahl.addHandler("tableCellDefaultBorder", this::applyTableCellDefaultBorder);
        ahl.addHandler("tableCellDefaultFont", this::applyTableCellDefaultFont);
        ahl.addHandler("tableContent", this::applyTableData);
        ahl.addHandler("tableGridColor", this::applyGridColor);
        ahl.addHandler("tableHeader", this::applyTableHeader);
        ahl.addHandler("tableHeaders", this::applyTableHeaders);
        ahl.addHandler("tableHeaderIcon", this::applyHeaderIcon);
        ahl.addHandler("tableInterCellSpacing", this::applyInterCellSpacing);
        ahl.addHandler("tableShowHorizontalLines", this::applyShowHorizontalLines);
        ahl.addHandler("tableShowVerticalLines", this::applyShowVerticalLines);
        ahl.addHandler("tableSelectionMode", this::applyTableSelectionMode);
        ahl.addHandler("wantChange", this::applyWantChange);
        this.mComponent = new CTable(this);
    }

    private boolean applyClear(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean clear = (Boolean)aValue;
            if (clear) {
                this.getComponent().getMyModel().clearRows();
            }
            return true;
        }
        return false;
    }

    private boolean applyFinish(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled) {
                this.getComponent().finish();
            }
            return true;
        }
        return false;
    }

    private boolean applyRowHeight(@NotNull String aKey, @Nullable Object aValue) {
        CEventSetRowHeight event = CEventSetRowHeight.create((Object)aValue);
        if (event != null) {
            String rowId = event.getRowId();
            int height = event.getHeight();
            if (CUtilString.isEmpty((String)rowId)) {
                this.getComponent().setRowHeight(height);
            } else {
                int rowIndex = this.mComponent.getMyModel().getRowModel().getRowIndex(rowId);
                if (rowIndex >= 0) {
                    this.getComponent().setRowHeight(rowIndex, height);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComponent().getSelectionModel().addListSelectionListener(this::onListSelection);
    }

    @NotNull
    private String getColumnHeader(int aColumnIndex) {
        Object value;
        TableColumn column;
        TableColumnModel cm;
        JTableHeader th = this.getComponent().getTableHeader();
        if (th != null && (cm = th.getColumnModel()) != null && (column = cm.getColumn(aColumnIndex)) != null && (value = column.getHeaderValue()) != null) {
            return value.toString();
        }
        return "";
    }

    private boolean applyInterCellSpacing(@NotNull String aKey, @Nullable Object aValue) {
        CEventDimension event = CEventDimension.create((Object)aValue);
        if (event != null) {
            this.getComponent().setIntercellSpacing(event.getDimension());
            return true;
        }
        return false;
    }

    private boolean applyGridColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getComponent().setGridColor(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyShowVerticalLines(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean show = (Boolean)aValue;
            this.getComponent().setShowVerticalLines(show);
            return true;
        }
        return false;
    }

    private boolean applyShowHorizontalLines(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean show = (Boolean)aValue;
            this.getComponent().setShowHorizontalLines(show);
            return true;
        }
        return false;
    }

    private boolean applyPack(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean pack = (Boolean)aValue;
            if (pack) {
                LOG.debug("Pack Table {}", new Object[]{this.getId()});
                this.getComponent().calcRowHeight();
                this.getComponent().invalidate();
            }
            return true;
        }
        return false;
    }

    private boolean applyResetCells(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean reset = (Boolean)aValue;
            if (reset) {
                this.getComponent().resetCells();
            }
            return true;
        }
        return false;
    }

    private boolean applyAutoResize(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String s = (String)aValue;
            ETableAutoResize autoResize = (ETableAutoResize)CUtilEnum.fromString(ETableAutoResize.class, (String)s, (Object)ETableAutoResize.allColumns);
            switch (autoResize) {
                case off: {
                    this.getComponent().setAutoResizeMode(0);
                    break;
                }
                case lastColumn: {
                    this.getComponent().setAutoResizeMode(3);
                    break;
                }
                case nextColumn: {
                    this.getComponent().setAutoResizeMode(1);
                    break;
                }
                case subsequentColumns: {
                    this.getComponent().setAutoResizeMode(2);
                    break;
                }
                default: {
                    this.getComponent().setAutoResizeMode(4);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyCells(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            for (Object o : arr.getChildren()) {
                this.applyTableCell(aKey, o);
            }
            this.getComponent().getMyModel().fireTableStructureChanged();
            return true;
        }
        return false;
    }

    private boolean applyTableCell(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableCell event = CEventTableCell.create((Object)aValue);
        if (event != null) {
            this.getComponent().applyTableCell(event);
            return true;
        }
        return false;
    }

    private boolean applyHeaderIcon(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableColumn event = CEventTableColumn.create((Object)aValue);
        if (event != null) {
            CTableModel model;
            CColumnModel columnModel;
            CColumn column;
            String id = event.getId();
            CEventIcon icon = event.getIcon();
            if (icon != null && (column = (columnModel = (model = this.getComponent().getMyModel()).getColumnModel()).getColumn(id)) != null) {
                CTableHeaderEntry header = column.getHeader();
                header.setIcon(icon.createIcon(this.getClass()));
            }
            return true;
        }
        return false;
    }

    private boolean applySizeColumnWidthToFit(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableColumn event = CEventTableColumn.create((Object)aValue);
        if (event != null) {
            String id = event.getId();
            CColumn column = this.getComponent().getMyModel().getColumnModel().getColumn(id);
            if (column != null) {
                if (Boolean.TRUE.equals(event.isWidthToFit())) {
                    column.sizeWidthToFit();
                }
                return true;
            }
            this.showErrorColumnNotFound("ColumnResizable", id);
        }
        return false;
    }

    private boolean applySortable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean sortable = (Boolean)aValue;
            if (sortable) {
                this.getComponent().setRowSorter(new TableRowSorter<CTableModel>(this.getComponent().getMyModel()));
            }
            return true;
        }
        return false;
    }

    private boolean applyHasHeader(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean hasHeader = (Boolean)aValue;
            this.getComponent().enableHeader(hasHeader);
            return true;
        }
        return false;
    }

    private boolean applyAlterColumn(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableColumn event = CEventTableColumn.create((Object)aValue);
        if (event != null) {
            return this.getComponent().getMyModel().getColumnModel().alterColumn(event);
        }
        return false;
    }

    private boolean applyAddColumn(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableColumn event = CEventTableColumn.create((Object)aValue);
        if (event != null) {
            this.getComponent().getMyModel().getColumnModel().addColumn(event);
            return true;
        }
        return false;
    }

    private boolean applyColumns(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableColumns event = CEventTableColumns.create((Object)aValue);
        if (event != null) {
            this.getComponent().getMyModel().getColumnModel().setColumns(event.getColumns());
            return true;
        }
        return false;
    }

    private boolean applySelectionBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getComponent().setSelectionBackground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applySelectionForeground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getComponent().setSelectionForeground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyTableCellDefaultBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getComponent().setCellDefaultBackground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyTableCellDefaultForeground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getComponent().setCellDefaultForeground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyTableCellDefaultBorder(@NotNull String aKey, @Nullable Object aValue) {
        IBorder border = CJsonBorderUtil.create((Object)aValue);
        if (border != null) {
            this.getComponent().setCellDefaultBorder(border.createBorder());
            return true;
        }
        return false;
    }

    private boolean applyTableCellDefaultFont(@NotNull String aKey, @Nullable Object aValue) {
        CEventFont event = CEventFont.create((Object)aValue);
        if (event != null) {
            this.getComponent().setCellDefaultFont(event.createFont());
            return true;
        }
        return false;
    }

    private boolean applyTableHeader(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableHeader event = CEventTableHeader.create((Object)aValue);
        if (event != null) {
            String columnId = event.getColumnId();
            CColumn column = this.getComponent().getMyModel().getColumnModel().getColumn(columnId);
            if (column != null) {
                CTableHeaderEntry header = column.getHeader();
                header.apply(event);
                return true;
            }
        }
        return false;
    }

    private boolean applyTableHeaders(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableHeaders event = CEventTableHeaders.create((Object)aValue);
        if (event != null) {
            for (CEventTableHeader header : event.getHeader()) {
                this.getComponent().getMyTableHeader().setHeader(header);
            }
            return true;
        }
        return false;
    }

    private boolean applyWantChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean wantChange = (Boolean)aValue;
            this.getComponent().setWantChange(wantChange);
            return true;
        }
        return false;
    }

    private boolean applyTableSelectionMode(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableSelectionMode event = CEventTableSelectionMode.create((Object)aValue);
        if (event != null) {
            this.getComponent().setCellSelectionEnabled(event.isCellSelectionEnabled());
            ListSelectionModel smc = this.getComponent().getColumnModel().getSelectionModel();
            switch (event.getColumnSelectionMode()) {
                case disabled: {
                    this.getComponent().setColumnSelectionAllowed(false);
                    break;
                }
                case single: {
                    this.getComponent().setColumnSelectionAllowed(true);
                    smc.setSelectionMode(0);
                    break;
                }
                case singleinterval: {
                    this.getComponent().setColumnSelectionAllowed(true);
                    smc.setSelectionMode(1);
                    break;
                }
                case multipleintervals: {
                    this.getComponent().setColumnSelectionAllowed(true);
                    smc.setSelectionMode(2);
                }
            }
            ListSelectionModel smr = this.getComponent().getSelectionModel();
            switch (event.getRowSelectionMode()) {
                case disabled: {
                    this.getComponent().setRowSelectionAllowed(false);
                    break;
                }
                case single: {
                    this.getComponent().setRowSelectionAllowed(true);
                    smr.setSelectionMode(0);
                    break;
                }
                case singleinterval: {
                    this.getComponent().setRowSelectionAllowed(true);
                    smr.setSelectionMode(1);
                    break;
                }
                case multipleintervals: {
                    this.getComponent().setRowSelectionAllowed(true);
                    smr.setSelectionMode(2);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyTableData(@NotNull String aKey, @Nullable Object aValue) {
        CEventTableContent event = CEventTableContent.create((Object)aValue);
        if (event != null) {
            this.getComponent().getMyModel().applyTableData(event);
            this.getComponent().invalidate();
            return true;
        }
        return false;
    }

    @NotNull
    public CTable getComponent() {
        return this.mComponent;
    }

    @NotNull
    private CTableItem getItem(@NotNull Point aPoint) {
        CTable table = this.getComponent();
        int rowIndex = table.rowAtPoint(aPoint);
        rowIndex = table.convertRowIndexToModel(rowIndex);
        CRow row = table.getMyModel().getRowModel().getRowByIndex(rowIndex);
        if (row != null) {
            int columnIndex = table.columnAtPoint(aPoint);
            CCell cell = row.getCellByIndex(columnIndex = table.convertColumnIndexToModel(columnIndex));
            if (cell != null) {
                return new CTableItem(cell.getRowId(), cell.getColumnId(), cell.getValueString());
            }
        }
        return new CTableItem("", "", "");
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Table.name();
    }

    public void updatePopupItem(@NotNull MouseEvent aEvent) {
        super.updatePopupItem(aEvent);
        Point point = aEvent.getPoint();
        CWidgetSet widgetSet = this.getWidgetSet();
        IRemoteSkinClientContext clientContext = widgetSet.getContext();
        List popupEvents = clientContext.getPopupEvents();
        popupEvents.add(point);
    }

    private void onListSelection(@NotNull ListSelectionEvent aListSelectionEvent) {
        if (!aListSelectionEvent.getValueIsAdjusting()) {
            int[] selectedColumns;
            int[] selectedRows;
            CEventTableSelectionNotification event = new CEventTableSelectionNotification();
            CTableModel model = this.getComponent().getMyModel();
            for (int selectedRow : selectedRows = this.getComponent().getSelectedRows()) {
                int modelRowIndex = this.getComponent().convertRowIndexToModel(selectedRow);
                CRow row = model.getRowModel().getRowByIndex(modelRowIndex);
                if (row == null) continue;
                event.addSelectedRow(row.getId());
            }
            for (int selectedColumn : selectedColumns = this.getComponent().getSelectedColumns()) {
                int modelColumnIndex = this.getComponent().convertColumnIndexToModel(selectedColumn);
                CColumn column = model.getColumnModel().getColumnByIndex(modelColumnIndex);
                if (column == null) continue;
                event.addSelectedColumn(column.getId());
            }
            this.addNotification("onTableSelection", event.toJson());
            this.sendNotification();
        }
    }

    public void enrichMouseEvent(@NotNull CEventMouseNotification aEvent) {
        super.enrichMouseEvent(aEvent);
        CTableItem item = this.getItem(aEvent.getPosition());
        aEvent.setRowId(item.getRowId());
        aEvent.setColumnId(item.getColumnId());
        aEvent.setValue(item.getContent());
    }

    public void enrichPopupEvent(@NotNull CEventPopupNotification aEvent) {
        super.enrichPopupEvent(aEvent);
        Point position = aEvent.getPosition();
        if (position != null) {
            CTableItem item = this.getItem(position);
            aEvent.setRowId(item.getRowId());
            aEvent.setColumnId(item.getColumnId());
            aEvent.setValue(item.getContent());
        }
    }

    private void showErrorColumnNotFound(@NotNull String aText, Object aColumn) {
        LOG.error("{}: Couldn't find column {}", new Object[]{aText, aColumn});
    }

    @Override
    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        super.fileArrived(aRelativePath, aToken, aImage);
        this.getComponent().fileArrived(aRelativePath, aToken, aImage);
    }
}

