/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.currentuser;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.currentuser.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.login.records.CRecordSessionLogout;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CAbstractWebDialog;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserRecord;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00315CurrentUser
extends CAbstractWebDialog {
    private String mUserId;
    private static final IId MICRO_SERVICE_CHANGE_PASSWORD = CIdFactory.fromObject((Object)"NY_WebDialogChangePassword_00309");
    private static final IId MICRO_SERVICE_EDIT_USER = CIdFactory.fromObject((Object)"NY_WebDialogEditUser_00301");
    private static final String ID_00315_CURRENT_USER = "id_00315_current_user";
    private static final String ID_00315_PICTURE = "id_00315_picture";
    private static final String ID_00315_CHANGE_PASSWORD = "id_00315_change_password";
    private static final String ID_00315_CHANGE_USER_DATA = "id_00315_change_user_data";
    private static final String ID_00315_LOGOUT = "id_00315_logout";
    private static final String ID_00315_LINK = "id_00315_link";
    private static final String STYLE_SHEET_ID = "id_00315_css";
    private static final String[] WIDGETS = new String[]{"id_00315_change_password", "id_00315_change_user_data", "id_00315_logout"};
    private CTargetAddress mUserDbAddress;

    public C00315CurrentUser(byte[] aSessionToken, @NotNull CTargetAddress aRemoteSkinAddress, @NotNull CTargetAddress aOwnerAddress, @NotNull String aParentWidgetId) {
        super(aSessionToken, aRemoteSkinAddress, aOwnerAddress, aParentWidgetId, CConstants.MICRO_SERVICE_ID);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
        this.addMessageHandler(CRecordUserDbGetUserRecord.ID, this::asyncGetUserRecord);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendSessionValidate();
        this.getWebApi().registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                this.mUserId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
                this.sendGetUserData(this.mUserId);
                this.showDialog();
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                String picture;
                this.mUserDbAddress = aEnvelope.getSender();
                CRecord userRecord = CRecordUserDbGetUserRecord.getUser((CRecord)aRecord, null);
                CUser user = CUser.fromRecord((CRecord)userRecord);
                if (user != null && CUtilString.isValid((String)(picture = user.getPicture()))) {
                    this.getWebApi().setInnerHtml(ID_00315_LINK, "<img id='id_00315_picture' src='images/temp.jpg' alt='" + this.mUserId + "'/>");
                    this.getWebApi().loadImage(picture, ID_00315_PICTURE);
                }
            } else if (resultCode == 5108) {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    public void notifyClick2(@NotNull String aWidgetId) throws CException {
        switch (aWidgetId) {
            case "id_00315_change_password": {
                this.openDialogChangePassword();
                break;
            }
            case "id_00315_change_user_data": {
                this.openDialogEditUser();
                break;
            }
            case "id_00315_logout": {
                this.sendLogout();
                this.finish(2);
            }
        }
    }

    private void showDialog() throws CException {
        this.getWebApi().addCss(STYLE_SHEET_ID, CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00315.css"));
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00315_main.html");
        this.getWebApi().setInnerHtml(this.getParentWidgetId(), main);
    }

    private void sendSessionValidate() throws CException {
        CRecord record = CRecordSessionValidate.create();
        this.sendMessageToSessionManager(record);
    }

    private void sendGetUserData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetUserRecord.create();
        CRecordUserDbGetUserRecord.setUserId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.getSessionToken());
        this.sendRequest(env, aRecord);
    }

    private void openDialogChangePassword() throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("userId", this.mUserId);
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_CHANGE_PASSWORD, this.getSessionToken(), "id_00300_modal", sp);
    }

    private void openDialogEditUser() throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("userId", this.mUserId);
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_EDIT_USER, this.getSessionToken(), "id_00300_modal", sp);
    }

    private void sendLogout() throws CException {
        CRecord record = CRecordSessionLogout.create();
        this.sendMessageToSessionManager(record);
    }

    protected void clearBeforeDismiss() throws CException {
        this.getWebApi().removeCss(STYLE_SHEET_ID);
        this.getWebApi().removeElement(ID_00315_CURRENT_USER);
    }
}

