/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.parser.xml;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.record.db.CRecordDatabase;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.ETransportDirection;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.jetbrains.annotations.NotNull;

final class CXmlWriter {
    private static final ILogger LOG = CLoggerFactory.getLogger(CXmlWriter.class);

    private CXmlWriter() {
    }

    public static void writeFile(@NotNull CRecordDatabase aRecordDatabase, @NotNull String aFilePath) throws CException {
        CXmlWriter.write(aRecordDatabase, aFilePath);
    }

    private static Document getDocument(CRecordDatabase aDatabase) {
        Element root = new Element("records");
        Collection records = aDatabase.getRecords();
        for (IRecordEntry record : records) {
            Element elementRecord = new Element("record");
            root.appendChild((Node)elementRecord);
            String value = record.getId().valueToString();
            Attribute attr = new Attribute("id", value);
            elementRecord.addAttribute(attr);
            value = record.getName();
            attr = new Attribute("name", value);
            elementRecord.addAttribute(attr);
            value = Boolean.toString(record.isNanoService());
            attr = new Attribute("isService", value);
            elementRecord.addAttribute(attr);
            value = Boolean.toString(record.hasOtherSlots());
            attr = new Attribute("hasOtherSlots", value);
            elementRecord.addAttribute(attr);
            value = record.getAccessType().name();
            attr = new Attribute("access", value);
            elementRecord.addAttribute(attr);
            String desc = record.getDescription();
            Element elementDesc = new Element("description");
            elementDesc.appendChild(desc);
            elementRecord.appendChild((Node)elementDesc);
            Collection namespaces = record.getNamespaces();
            for (String namespace : namespaces) {
                Element elementNs = new Element("namespaces");
                elementNs.appendChild(namespace);
                elementRecord.appendChild((Node)elementNs);
            }
            Iterator itSlot = record.getSlots();
            while (itSlot.hasNext()) {
                ISlotRecord slot = (ISlotRecord)itSlot.next();
                Element elementSlot = new Element("slot");
                elementRecord.appendChild((Node)elementSlot);
                value = slot.getKey();
                attr = new Attribute("key", value);
                elementSlot.addAttribute(attr);
                value = slot.getName();
                attr = new Attribute("name", value);
                elementSlot.addAttribute(attr);
                value = slot.getSlotTypeName();
                attr = new Attribute("type", value);
                elementSlot.addAttribute(attr);
                ETransportDirection direction = slot.getTransportDirection();
                value = direction.toString();
                attr = new Attribute("direction", value);
                elementSlot.addAttribute(attr);
                value = Boolean.toString(slot.isMandatory());
                attr = new Attribute("mandatory", value);
                elementSlot.addAttribute(attr);
                desc = slot.getDescription();
                elementDesc = new Element("description");
                elementDesc.appendChild(desc);
                elementSlot.appendChild((Node)elementDesc);
            }
        }
        return new Document(root);
    }

    static String getFormattedXml(CRecordDatabase aDatabase) throws CException {
        Document doc = CXmlWriter.getDocument(aDatabase);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)baos, "ISO-8859-1");
            serializer.setIndent(4);
            serializer.write(doc);
            return baos.toString("ISO-8859-1");
        }
        catch (Exception e) {
            throw new CException((Throwable)e);
        }
    }

    static String getXml(CRecordDatabase aDatabase) {
        Document doc = CXmlWriter.getDocument(aDatabase);
        return doc.toXML();
    }

    static void write(CRecordDatabase aDatabase, String aFilePath) throws CException {
        if (aFilePath == null || aFilePath.isEmpty()) {
            throw new CException(7).append("Empty file path for writing message file.");
        }
        Document doc = CXmlWriter.getDocument(aDatabase);
        try {
            File file = new File(aFilePath);
            FileOutputStream fos = new FileOutputStream(file);
            Serializer serializer = new Serializer((OutputStream)fos, "ISO-8859-1");
            serializer.setIndent(4);
            serializer.write(doc);
        }
        catch (IOException ex) {
            LOG.error("Error writing XML", new Object[]{ex});
        }
    }
}

