/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.link;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.network.link.CLinkDto;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CUtilLink {
    private CUtilLink() {
    }

    public static void someMethod(@NotNull List<CLinkDto> aLinkList) {
        Set<CNodeAddress> setOfNodeIds = CUtilLink.createSetOfNodeIds(aLinkList);
        CNodeAddress[] nodes = new CNodeAddress[setOfNodeIds.size()];
        nodes = setOfNodeIds.toArray(nodes);
        int linkCount = aLinkList.size();
        int[] index1 = new int[linkCount];
        int[] index2 = new int[linkCount];
        ZonedDateTime[] costMeasureTimes = new ZonedDateTime[linkCount];
        int[] costs = new int[linkCount];
        int i = 0;
        for (CLinkDto link : aLinkList) {
            CNodeAddress node1 = link.getNode1();
            index1[i] = CUtilLink.getIndex(nodes, node1);
            CNodeAddress node2 = link.getNode2();
            index2[i] = CUtilLink.getIndex(nodes, node2);
            costMeasureTimes[i] = link.getTimeOfMeasurement();
            costs[i] = link.getCosts();
            ++i;
        }
    }

    @NotNull
    public static Set<CNodeAddress> createSetOfNodeIds(@NotNull List<CLinkDto> aLinks) {
        HashSet<CNodeAddress> nodeArray = new HashSet<CNodeAddress>();
        for (CLinkDto link : aLinks) {
            CNodeAddress node1 = link.getNode1();
            CNodeAddress node2 = link.getNode2();
            nodeArray.add(node1);
            nodeArray.add(node2);
        }
        return nodeArray;
    }

    @Contract(pure=true)
    private static int getIndex(CNodeAddress @NotNull [] aNodeIdArray, CNodeAddress aSearch) {
        for (int i = 0; i < aNodeIdArray.length; ++i) {
            if (!aNodeIdArray[i].equals((Object)aSearch)) continue;
            return i;
        }
        return -1;
    }
}

