/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.CSessionEntry;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionExpired;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CByteArrayHashKey;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.crypt.CUtilAes;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CSessionList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSessionList.class);
    private final Map<CByteArrayHashKey, CSessionEntry> mLongTokenToSession = new ConcurrentHashMap<CByteArrayHashKey, CSessionEntry>();
    private final Map<CByteArrayHashKey, CSessionEntry> mShortTokenToSession = new ConcurrentHashMap<CByteArrayHashKey, CSessionEntry>();
    private final IDependencies mDependencies;
    private final ILocalService mLocalService;

    CSessionList(@NotNull IDependencies aDependencies, @NotNull ILocalService aLocalService) {
        this.mDependencies = aDependencies;
        this.mLocalService = aLocalService;
        try {
            this.readFromStorage();
        }
        catch (CException aE) {
            LOG.error("Error reading session tokens", new Object[]{aE});
        }
    }

    void add(@NotNull CSessionEntry aSession, boolean aWriteStorage) {
        byte[] longToken = aSession.getLongToken();
        if (longToken != null) {
            CByteArrayHashKey longKey = new CByteArrayHashKey(longToken);
            this.mLongTokenToSession.put(longKey, aSession);
            byte[] shortToken = aSession.getShortToken();
            CByteArrayHashKey shortKey = new CByteArrayHashKey(shortToken);
            this.mShortTokenToSession.put(shortKey, aSession);
            if (aWriteStorage) {
                try {
                    this.writeToStorage();
                }
                catch (CException aE) {
                    LOG.error("Error writing session tokens", new Object[]{aE});
                }
            }
        }
    }

    CSessionEntry remove(byte[] aToken) {
        CSessionEntry entry = null;
        if (aToken != null) {
            CByteArrayHashKey key = new CByteArrayHashKey(aToken);
            if (aToken.length == 16) {
                entry = this.mShortTokenToSession.remove(key);
                if (entry != null) {
                    CByteArrayHashKey longKey = new CByteArrayHashKey(entry.getLongToken());
                    this.mLongTokenToSession.remove(longKey);
                }
            } else {
                entry = this.mLongTokenToSession.remove(key);
                if (entry != null) {
                    CByteArrayHashKey shortKey = new CByteArrayHashKey(entry.getShortToken());
                    this.mShortTokenToSession.remove(shortKey);
                }
            }
        }
        return entry;
    }

    CSessionEntry get(byte[] aToken) {
        if (aToken != null) {
            CByteArrayHashKey key = new CByteArrayHashKey(aToken);
            if (aToken.length == 16) {
                return this.mShortTokenToSession.get(key);
            }
            return this.mLongTokenToSession.get(key);
        }
        return null;
    }

    public String toString() {
        return "[SessionList: " + this.mLongTokenToSession.size() + " entries]";
    }

    void doMaintenance(@NotNull ITarget aTarget) {
        for (CSessionEntry entry : this.mLongTokenToSession.values()) {
            if (!this.isSessionExpired(entry, aTarget)) continue;
            this.remove(entry.getShortToken());
        }
    }

    private boolean isSessionExpired(@NotNull CSessionEntry aSession, @NotNull ITarget aTarget) {
        boolean expired = aSession.isExpired();
        if (expired) {
            LOG.debug("Session expired: {}", new Object[]{CUtilByteArray.toString((byte[])aSession.getLongToken(), (char)',', (int)50)});
            this.sendSessionExpiredNotification(aSession, aTarget.getAddress());
        }
        return expired;
    }

    private void sendSessionExpiredNotification(@NotNull CSessionEntry aSession, @NotNull CTargetAddress aSender) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordSessionExpired.class);
            env.setSessionToken(aSession.getLongToken());
            env.setSender(aSender);
            CRecord record = CRecordSessionExpired.create();
            this.mDependencies.getBroadcastService().broadcastMessage(env, record, true);
        }
        catch (CException aException) {
            LOG.error((Throwable)aException);
        }
    }

    @Nullable
    private SecretKey getSecretKey() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("session");
        String s = preferences.get("key.aes.storage", null);
        if (s != null) {
            byte[] ss = CUtilBase64.decode((String)s);
            return new SecretKeySpec(ss, 0, ss.length, "AES");
        }
        return null;
    }

    @Nullable
    private File getStorageFile() {
        File result = null;
        Path storagePath = this.mDependencies.getKernelConfiguration().getStoragePath();
        if (storagePath != null) {
            Path sessionPath = storagePath.resolve("session");
            CUtilFile.createDirectories((Path)sessionPath);
            Path path = sessionPath.resolve("session.aes");
            result = path.toFile();
        }
        return result;
    }

    private void writeToStorage() throws CException {
        File file;
        SecretKey secretKey = this.getSecretKey();
        if (secretKey != null && (file = this.getStorageFile()) != null) {
            try (ByteArrayOutputStream baOs = new ByteArrayOutputStream();
                 DataOutputStream dos = new DataOutputStream(baOs);){
                CUtilInteger.toStream((DataOutput)dos, (int)this.mLongTokenToSession.size());
                for (CSessionEntry value : this.mLongTokenToSession.values()) {
                    value.toStream(dos);
                }
                baOs.flush();
                byte[] bytes = baOs.toByteArray();
                byte[] packed = CUtilAes.pack((SecretKey)secretKey, (byte[])bytes);
                try (FileOutputStream fos = new FileOutputStream(file);
                     DataOutputStream dos2 = new DataOutputStream(fos);){
                    dos2.write(packed);
                }
            }
            catch (Exception aE) {
                throw new CException((Throwable)aE);
            }
        }
    }

    private void readFromStorage() throws CException {
        File file;
        SecretKey secretKey = this.getSecretKey();
        if (secretKey != null && (file = this.getStorageFile()) != null && file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                byte[] fileContent = bos.toByteArray();
                byte[] unpacked = CUtilAes.unpack((SecretKey)secretKey, (byte[])fileContent);
                try (ByteArrayInputStream baIn = new ByteArrayInputStream(unpacked);
                     DataInputStream dis = new DataInputStream(baIn);){
                    int count = CUtilInteger.fromStream((DataInput)dis);
                    for (int i = 0; i < count; ++i) {
                        CSessionEntry entry = CSessionEntry.fromStream(this.mLocalService, dis);
                        if (entry.isExpired()) continue;
                        this.add(entry, false);
                    }
                }
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException aE) {
                throw new CException((Throwable)aE);
            }
        }
    }
}

