/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.gatekeeper;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.gatekeeper.IGateKeeperRule;
import de.sillysky.nyssr.gatekeeper.records.CRecordDataGateKeeperRule;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CGateKeeperRule
implements IGateKeeperRule {
    private final boolean mAllow;
    private final int mGate;
    private final IId mRecordID;
    private final IId mReceiverNID;
    private final CNodeId mSenderNodeId;
    private final String mDescription;

    CGateKeeperRule(boolean aAllow, int aPort, IId aRecordID, IId aReceiverNID, CNodeId aSenderNodeId, String aDescription) {
        this.mAllow = aAllow;
        this.mGate = aPort;
        this.mRecordID = aRecordID;
        this.mReceiverNID = aReceiverNID;
        this.mSenderNodeId = aSenderNodeId;
        this.mDescription = aDescription;
    }

    public CGateKeeperRule(CRecord aRecord) {
        this.mAllow = CRecordDataGateKeeperRule.getIsAllowRule((CRecord)aRecord, (boolean)false);
        this.mGate = CRecordDataGateKeeperRule.getGate((CRecord)aRecord, (int)0);
        this.mRecordID = CRecordDataGateKeeperRule.getRecordId((CRecord)aRecord, null);
        this.mReceiverNID = CRecordDataGateKeeperRule.getReceiverNid((CRecord)aRecord, null);
        this.mSenderNodeId = CRecordDataGateKeeperRule.getSenderNodeId((CRecord)aRecord, null);
        this.mDescription = CRecordDataGateKeeperRule.getDescription((CRecord)aRecord, (String)"");
    }

    boolean equals(IId aMID, IId aReceiverNID, CNodeId aSenderNodeId) {
        boolean result = false;
        if (CIdFactory.equals((IId)this.mRecordID, (IId)aMID) && CIdFactory.equals((IId)this.mReceiverNID, (IId)aReceiverNID) && CNodeId.equals((CNodeId)this.mSenderNodeId, (CNodeId)aSenderNodeId)) {
            result = true;
        }
        return result;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public int getGate() {
        return this.mGate;
    }

    public IId getReceiverNID() {
        return this.mReceiverNID;
    }

    public IId getRecordId() {
        return this.mRecordID;
    }

    public CNodeId getSenderNodeId() {
        return this.mSenderNodeId;
    }

    public boolean isAllowRule() {
        return this.mAllow;
    }

    public boolean match(int aGate, @Nullable IId aRecordId, @Nullable IId aNID, @Nullable CNodeId aNodeId) {
        return !(this.mGate > 0 && aGate != this.mGate || this.mRecordID != null && !CIdFactory.equals((IId)this.mRecordID, (IId)aRecordId) || this.mReceiverNID != null && !this.mReceiverNID.equals((Object)CWellKnownNID.ALL) && !this.mReceiverNID.equals((Object)aNID) || this.mSenderNodeId != null && !this.mSenderNodeId.equals((Object)aNodeId));
    }

    @NotNull
    public CRecord ruleToRecord() throws CException {
        CRecord rec = CRecordDataGateKeeperRule.create();
        CRecordDataGateKeeperRule.setDescription((CRecord)rec, (String)this.mDescription);
        CRecordDataGateKeeperRule.setGate((CRecord)rec, (int)this.mGate);
        CRecordDataGateKeeperRule.setIsAllowRule((CRecord)rec, (boolean)this.mAllow);
        CRecordDataGateKeeperRule.setReceiverNid((CRecord)rec, (IId)this.mReceiverNID);
        CRecordDataGateKeeperRule.setRecordId((CRecord)rec, (IId)this.mRecordID);
        CRecordDataGateKeeperRule.setSenderNodeId((CRecord)rec, (CNodeId)this.mSenderNodeId);
        return rec;
    }

    public String toString() {
        return this.mDescription;
    }
}

