/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.collector;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.microservice.registry.records.CRecordMicroService;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.record.IRecordIO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CMicroServiceDescription
implements Comparable<CMicroServiceDescription>,
IRecordIO {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMicroServiceDescription.class);
    @NotNull
    private final IId mId;
    @NotNull
    private final String mDescription;
    private final Set<CDescriptionOfRecord> mDescriptionOfRecords = new HashSet<CDescriptionOfRecord>();

    public CMicroServiceDescription(@NotNull IId aId, @NotNull String aDescription, @NotNull Collection<CDescriptionOfRecord> aDescriptionOfRecords) {
        this.mId = aId;
        this.mDescription = aDescription;
        this.mDescriptionOfRecords.addAll(aDescriptionOfRecords);
    }

    @SafeVarargs
    public CMicroServiceDescription(@NotNull IId aId, @NotNull String aDescription, Class<? extends IGeneratedRecord> ... aClasses) {
        this.mId = aId;
        this.mDescription = aDescription;
        for (Class<? extends IGeneratedRecord> clazz : aClasses) {
            try {
                Field f = clazz.getDeclaredField("ID");
                IId id = (IId)f.get(null);
                f = clazz.getDeclaredField("DESCRIPTION");
                String desc = (String)f.get(null);
                this.mDescriptionOfRecords.add(new CDescriptionOfRecord(id, desc));
            }
            catch (Exception aE) {
                LOG.error((Throwable)aE, "No record id found in record class");
            }
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CMicroServiceDescription fromRecord(@NotNull CRecord aRecord) throws CException {
        CUtilCheck.checkTrueEx((boolean)CRecordMicroService.ID.equals((Object)aRecord.getId()), (String)"Wrong Record ID", (Object[])new Object[0]);
        IId id = CRecordMicroService.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"MID is null", (Object[])new Object[0]);
        String s = CRecordMicroService.getDescription((CRecord)aRecord, (String)"");
        String description = s == null ? "" : s;
        CRecord[] rr = CRecordMicroService.getApi((CRecord)aRecord, null);
        ArrayList<CDescriptionOfRecord> api = new ArrayList<CDescriptionOfRecord>();
        if (rr != null) {
            for (CRecord r : rr) {
                try {
                    CDescriptionOfRecord n = CDescriptionOfRecord.fromRecord((CRecord)r);
                    api.add(n);
                }
                catch (CException aE) {
                    LOG.error((Throwable)aE, "No record id found in record description");
                }
            }
        }
        return new CMicroServiceDescription(id, description, api);
    }

    public void addRecordDescription(@NotNull CDescriptionOfRecord aDescriptionOfRecords) {
        this.mDescriptionOfRecords.add(aDescriptionOfRecords);
    }

    @Override
    public int compareTo(@NotNull CMicroServiceDescription aOther) {
        return this.mId.compareTo((Object)aOther.mId);
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CMicroServiceDescription that = (CMicroServiceDescription)aO;
        return this.mId.equals((Object)that.mId);
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    @NotNull
    public Collection<CDescriptionOfRecord> getDescriptionOfRecords() {
        return new ArrayList<CDescriptionOfRecord>(this.mDescriptionOfRecords);
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public String toString() {
        return "{" + String.valueOf(this.mId) + " (" + this.mDescription + ")}";
    }

    public CRecord valueToRecord() throws CException {
        CRecord rec = CRecordMicroService.create();
        CRecordMicroService.setId((CRecord)rec, (IId)this.mId);
        CRecordMicroService.setDescription((CRecord)rec, (String)this.mDescription);
        if (!this.mDescriptionOfRecords.isEmpty()) {
            CRecord[] arr = new CRecord[this.mDescriptionOfRecords.size()];
            int i = 0;
            for (CDescriptionOfRecord n : this.mDescriptionOfRecords) {
                arr[i++] = n.valueToRecord();
            }
            CRecordMicroService.setApi((CRecord)rec, (CRecord[])arr);
        }
        return rec;
    }
}

