/*
 * Copyright (c) since 2023 by sillysky.net.
 * All rights reserved.
 * This file is subject to the terms and conditions defined in file 'LICENSE.txt',
 * which is part of this source code package.
 */

package de.sillysky.nyssr.module;

import de.sillysky.nyssr.impl.example001.CPackageImplExample001;
import de.sillysky.nyssr.plugin.IPlugIn;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.version.CVersionHelper;
import org.jetbrains.annotations.NotNull;

import java.net.URL;

public class CModuleExample001 implements IPlugIn
{
    @Override
    public void startPlugin(@NotNull final URL aUrl,
                            @NotNull final ClassLoader aClassLoader,
                            @NotNull final IServiceRegistry aServiceRegistry)
    {
        // Print JAR version into the LOG
        CVersionHelper.printJarVersion(aUrl);

        // Initialize the package "de.sillysky.nyssr.impl.example001" by adding the ServiceStarter Interface
        // to the service registry.
        // The service registry will start the package if the dependencies of the package are fulfilled.
        aServiceRegistry.addStarter(new CPackageImplExample001());
    }
}
