package de.sillysky.nyssr.impl.example001;


import de.sillysky.nyssr.address.CTargetAddress;
import org.jetbrains.annotations.NotNull;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;

class CPingEntry
{
    private static final AtomicInteger IDS = new AtomicInteger(0);
    private final long mId;
    private final CTargetAddress mTargetAddress;
    private long mCounter = 0L;
    private final LocalTime mStartTime = LocalTime.now();

    CPingEntry(@NotNull final CTargetAddress aTargetAddress)
    {
        mId = IDS.incrementAndGet();
        mTargetAddress = aTargetAddress;
    }

    long getId()
    {
        return mId;
    }

    @NotNull CTargetAddress getTargetAddress()
    {
        return mTargetAddress;
    }

    long getCounter()
    {
        return mCounter;
    }

    @Override
    public boolean equals(final Object aO)
    {
        if (aO == null || getClass() != aO.getClass())
        {
            return false;
        }

        final CPingEntry that = (CPingEntry) aO;
        return mId == that.mId;
    }

    @Override
    public int hashCode()
    {
        return Long.hashCode(mId);
    }

    public void incCounter()
    {
        mCounter++;
    }

    public double getPingsPerHour()
    {
        LocalTime now = LocalTime.now();

        long seconds = ChronoUnit.SECONDS.between(mStartTime,
                                                  now);

        if (seconds == 0)
        {
            return 0.0;
        }

        double entriesPerSecond = (double) mCounter / seconds;

        return entriesPerSecond * 3600;
    }
}
