/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.example001;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.example001.CPingEntry;
import de.sillysky.nyssr.impl.example001.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.records.CRecordPing;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.cmdline.CSimpleArgParser;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CServiceExample001
extends CTarget
implements IService {
    private static final String PING = "ping";
    private static final String HELP_PING = "--target [targetAddress]               : ping a target\n    --nodes [node IDs separated by commas] : ping a target PING.SYSTEM.[nodeId].[local segment id]\n    -l                                     : list all currently active pings\n    --delete pingId                        : delete a ping\n    --delete *                             : delete all pings";
    @NotNull
    private final IDependencies mDependencies;
    private final Map<Long, CPingEntry> mPingEntries = new HashMap<Long, CPingEntry>();

    CServiceExample001(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
        this.addMessageHandler(CRecordPing.ID, this::asyncPing);
    }

    public void activate(@NotNull IServiceRegistry aIServiceRegistry) throws Exception {
        INamespace namespace = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (namespace != null);
        namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aIServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerCli();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String[] arguments;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (PING.equals(command) && (arguments = CRecordCliHandle.getArguments((CRecord)aRecord, null)).length > 0) {
            String del;
            boolean doList;
            String nodes;
            CSimpleArgParser p = new CSimpleArgParser(arguments);
            String at = p.getOption("target");
            if (at != null) {
                this.addTargetAddress(at);
            }
            if ((nodes = p.getOption("nodes")) != null) {
                String[] nodeArr;
                for (String node : nodeArr = nodes.split(",")) {
                    this.addNodeId(node);
                }
            }
            if (doList = p.hasFlag("l")) {
                this.printList();
            }
            if ((del = p.getOption("delete")) != null) {
                if ("*".equals(del)) {
                    this.printList();
                    this.mPingEntries.clear();
                    System.out.println("All ping entries removed");
                } else {
                    long id = Long.parseLong(del);
                    CPingEntry removed = this.mPingEntries.remove(id);
                    if (removed == null) {
                        System.out.println("ID not found: " + id);
                    } else {
                        System.out.println("Ping entries removed:");
                        System.out.println(this.createDumpLine(removed));
                    }
                }
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void addTargetAddress(String aAt) throws CException {
        CTargetAddress targetAddress = CTargetAddress.fromString((String)aAt);
        if (targetAddress != null) {
            CPingEntry pe = new CPingEntry(targetAddress);
            this.mPingEntries.put(pe.getId(), pe);
            this.sendPing(pe);
        }
    }

    private void addNodeId(String aNode) throws CException {
        CNodeId nodeId = new CNodeId(aNode);
        CTargetAddress targetAddress = new CTargetAddress(CWellKnownTID.PING, CWellKnownNID.SYSTEM, nodeId, CSegmentId.getLocal());
        CPingEntry pe = new CPingEntry(targetAddress);
        this.mPingEntries.put(pe.getId(), pe);
        System.out.println("Adding " + aNode + aNode + ", ID=" + pe.getId());
        this.sendPing(pe);
    }

    private void printList() {
        System.out.printf("%8s %30s %8s %14s %14s%n", "ID", "address", "pings", "pingsPerHour", "msgPerSecond");
        System.out.println("------------------------------------------------------------------------------");
        StringBuilder sb = new StringBuilder();
        for (CPingEntry pe : this.mPingEntries.values()) {
            sb.append(this.createDumpLine(pe));
        }
        System.out.println(sb);
    }

    @NotNull
    private String createDumpLine(@NotNull CPingEntry aEntry) {
        return String.format("%8s %30s %8s %,14.0f %,14.0f%n", aEntry.getId(), aEntry.getTargetAddress(), aEntry.getCounter(), aEntry.getPingsPerHour(), aEntry.getPingsPerHour() / 1800.0);
    }

    private boolean asyncPing(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            long id = CRecordPing.getLoopMirror((CRecord)aRecord, (long)0L);
            if (aEnvelope.getResultCode() == 0) {
                CPingEntry pe = this.mPingEntries.get(id);
                if (pe != null) {
                    pe.incCounter();
                    this.sendPing(pe);
                }
            } else {
                this.mPingEntries.remove(id);
            }
            return true;
        }
        return false;
    }

    private void registerCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{PING});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{HELP_PING});
        this.sendNotification(env, record);
    }

    private void sendPing(@NotNull CPingEntry aPingEntry) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aPingEntry.getTargetAddress());
        CRecord record = CRecordPing.create();
        CRecordPing.setLoop((CRecord)record, (long)aPingEntry.getId());
        this.sendRequest(env, record);
    }
}

