/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.example001;

import de.sillysky.nyssr.address.CTargetAddress;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class CPingEntry {
    private static final AtomicInteger IDS = new AtomicInteger(0);
    private final long mId;
    private final CTargetAddress mTargetAddress;
    private long mCounter = 0L;
    private LocalTime mStartTime = LocalTime.now();

    CPingEntry(@NotNull CTargetAddress aTargetAddress) {
        this.mId = IDS.incrementAndGet();
        this.mTargetAddress = aTargetAddress;
    }

    long getId() {
        return this.mId;
    }

    @NotNull
    CTargetAddress getTargetAddress() {
        return this.mTargetAddress;
    }

    long getCounter() {
        return this.mCounter;
    }

    public boolean equals(Object aO) {
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CPingEntry that = (CPingEntry)aO;
        return this.mId == that.mId;
    }

    public int hashCode() {
        return Long.hashCode(this.mId);
    }

    public void incCounter() {
        ++this.mCounter;
    }

    public double getPingsPerHour() {
        LocalTime now = LocalTime.now();
        long seconds = ChronoUnit.SECONDS.between(this.mStartTime, now);
        if (seconds == 0L) {
            return 0.0;
        }
        double entriesPerSecond = (double)this.mCounter / (double)seconds;
        return entriesPerSecond * 3600.0;
    }
}

