/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRightRecord;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CRight
implements Comparable<CRight> {
    private String mId;
    private String mDescription;
    private final boolean mProtected;

    @NotNull
    public static CRight fromRecord(@NotNull CRecord aRecord) throws CException {
        if (!CRecordUserDbRightRecord.ID.equals((Object)aRecord.getId())) {
            throw new CException(2010);
        }
        String id = CRecordUserDbRightRecord.getRightId(aRecord, "");
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"missing right id", (Object[])new Object[0]);
        String description = CRecordUserDbRightRecord.getDescription(aRecord, "");
        boolean isProtected = CRecordUserDbRightRecord.getIsProtected(aRecord, false);
        return new CRight(id, description, isProtected);
    }

    public CRight(@NotNull String aId, @NotNull String aDescription, boolean aProtected) {
        this.mId = aId;
        this.mDescription = aDescription;
        this.mProtected = aProtected;
    }

    public CRight() {
        this.mId = "";
        this.mDescription = "";
        this.mProtected = false;
    }

    @NotNull
    public static CRight fromStream(@NotNull DataInputStream aStream) throws IOException, CException {
        String id = CUtilString.fromStream((DataInput)aStream);
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"missing id", (Object[])new Object[0]);
        assert (id != null);
        String desc = CUtilString.fromStream((DataInput)aStream);
        boolean isProtected = aStream.readBoolean();
        return new CRight(id, desc == null ? "" : desc, isProtected);
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CRight right = (CRight)aO;
        return this.mId.equals(right.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public void setId(@NotNull String aRightId) {
        this.mId = aRightId;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordUserDbRightRecord.create();
        CRecordUserDbRightRecord.setRightId(record, this.mId);
        CRecordUserDbRightRecord.setDescription(record, this.mDescription);
        CRecordUserDbRightRecord.setIsProtected(record, this.mProtected);
        return record;
    }

    @Override
    public int compareTo(@NotNull CRight aRight) {
        return this.mId.compareTo(aRight.mId);
    }

    @NotNull
    public String toString() {
        return this.mId;
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        CUtilString.toStream((DataOutput)aStream, (String)this.mId);
        CUtilString.toStream((DataOutput)aStream, (String)this.mDescription);
        aStream.writeBoolean(this.mProtected);
    }
}

