/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilDisplay;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventSliderStandardLabels;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetOrientation;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Component;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingSlider
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSlider.class);
    private final JSlider mComponent = new JSlider();
    private boolean mOnChange = false;
    private boolean mOnEveryChange = false;
    private CWidget mDisplayWidget;

    CSwingSlider(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("display", this::applyDisplay);
        list.addHandler("extent", this::applyExtent);
        list.addHandler("inverted", this::applyInverted);
        list.addHandler("labels", this::applyLabels);
        list.addHandler("majorTickSpacing", this::applyMajorTickSpacing);
        list.addHandler("maximum", this::applyMaximum);
        list.addHandler("maximumSize", this::applyMaximum);
        list.addHandler("minimum", this::applyMinimum);
        list.addHandler("minimumSize", this::applyMinimum);
        list.addHandler("minorTickSpacing", this::applyMinorTickSpacing);
        list.addHandler("wantChange", this::applyWantChange);
        list.addHandler("wantEveryChange", this::applyOnEveryChange);
        list.addHandler("orientation", this::applyOrientation);
        list.addHandler("paintLabels", this::applyPaintLabels);
        list.addHandler("paintTrack", this::applyPaintTrack);
        list.addHandler("paintTicks", this::applyPaintTicks);
        list.addHandler("snapToTicks", this::applySnapToTicks);
        list.addHandler("standardLabels", this::applyStandardLabels);
        list.addHandler("value", this::applyValue);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComponent().addChangeListener(e -> {
            if (this.mDisplayWidget != null) {
                this.doDisplay();
            }
            if (this.mOnChange || this.mOnEveryChange) {
                CEventInteger event = new CEventInteger(this.getComponent().getValue());
                Object jo = event.toJson();
                this.addNotification("onSliderChange", jo);
                this.sendNotification();
            }
        });
    }

    private boolean applyDisplay(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String id = (String)aValue;
            if (CUtilReference.isWidgetId((String)id)) {
                this.mDisplayWidget = this.getWidgetSet().findWidget(id);
            }
            this.doDisplay();
            this.getComponent().addChangeListener(e -> this.doDisplay());
            return true;
        }
        return false;
    }

    private boolean applyExtent(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int extent = CUtilInteger.fromObject((Object)aValue, (int)5);
            LOG.debug("Set extent to {}", new Object[]{Integer.toString(extent)});
            this.getComponent().setExtent(extent);
            return true;
        }
        return false;
    }

    private boolean applyInverted(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set inverted to {}", new Object[]{Boolean.toString(b)});
            this.getComponent().setInverted(b);
            return true;
        }
        return false;
    }

    private boolean applyLabels(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject obj = (CJsonObject)aValue;
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            for (String key : obj.keys()) {
                if (!CUtilInteger.isNumeric((String)key)) continue;
                int position = CUtilInteger.fromString((String)key);
                Object o = obj.getValue(key);
                ((Dictionary)labels).put(position, new JLabel(o == null ? "null" : o.toString()));
            }
            if (!((Dictionary)labels).isEmpty()) {
                LOG.debug("Set label table for positions {}", new Object[]{((Dictionary)labels).keys()});
                this.getComponent().setLabelTable(labels);
                return true;
            }
        }
        return false;
    }

    private boolean applyMajorTickSpacing(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int tickSpacing = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set major tick spacing to {}", new Object[]{tickSpacing});
            this.getComponent().setMajorTickSpacing(tickSpacing);
            return true;
        }
        return false;
    }

    private boolean applyMaximum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int max = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set maximum to {}", new Object[]{max});
            this.getComponent().setMaximum(max);
            return true;
        }
        return false;
    }

    private boolean applyMinimum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int min = CUtilInteger.fromObject((Object)aValue, (int)1);
            LOG.debug("Set minimum to {}", new Object[]{min});
            this.getComponent().setMinimum(min);
            return true;
        }
        return false;
    }

    private boolean applyMinorTickSpacing(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int minorTickSpacing = CUtilInteger.fromObject((Object)aValue, (int)2);
            LOG.debug("Set minor tick spacing to {}", new Object[]{minorTickSpacing});
            this.getComponent().setMinorTickSpacing(minorTickSpacing);
            return true;
        }
        return false;
    }

    private boolean applyWantChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnEveryChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnEveryChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventWidgetOrientation event = CEventWidgetOrientation.create((Object)aValue);
        if (event != null) {
            EWidgetOrientation orientation = event.getOrientation();
            LOG.debug("Set orientation to {}", new Object[]{orientation});
            switch (orientation) {
                case horizontal: {
                    this.getComponent().setOrientation(0);
                    return true;
                }
                case vertical: {
                    this.getComponent().setOrientation(1);
                    return true;
                }
            }
            LOG.error("Unknown Slider Orientation: {}", new Object[]{orientation});
        }
        return false;
    }

    private boolean applyPaintLabels(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean paintLabels = (Boolean)aValue;
            LOG.debug("Set paint labels to {}", new Object[]{Boolean.toString(paintLabels)});
            this.getComponent().setPaintLabels(paintLabels);
            return true;
        }
        return false;
    }

    private boolean applyPaintTicks(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean paintTicks = (Boolean)aValue;
            LOG.debug("Set paint ticks to {}", new Object[]{Boolean.toString(paintTicks)});
            this.getComponent().setPaintTicks(paintTicks);
            return true;
        }
        return false;
    }

    private boolean applyPaintTrack(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean paintTrack = (Boolean)aValue;
            LOG.debug("Set paint track to {}", new Object[]{Boolean.toString(paintTrack)});
            this.getComponent().setPaintTrack(paintTrack);
            return true;
        }
        return false;
    }

    private boolean applySnapToTicks(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean snapToTicks = (Boolean)aValue;
            LOG.debug("Set snap to ticks to {}", new Object[]{Boolean.toString(snapToTicks)});
            this.getComponent().setSnapToTicks(snapToTicks);
            return true;
        }
        return false;
    }

    private boolean applyStandardLabels(@NotNull String aKey, @Nullable Object aValue) {
        CEventSliderStandardLabels event = CEventSliderStandardLabels.create((Object)aValue);
        if (event != null) {
            int stepLabel = event.getStepLabelPosition();
            int startLabel = event.getStartLabelPosition();
            LOG.debug("Create standard labels at position {} starting at {}", new Object[]{stepLabel, startLabel});
            Hashtable<Integer, JComponent> standardLabels = this.getComponent().createStandardLabels(stepLabel, startLabel);
            this.getComponent().setLabelTable(standardLabels);
            return true;
        }
        return false;
    }

    private boolean applyValue(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)0);
            LOG.debug("Set value to {}", new Object[]{value});
            this.getComponent().setValue(value);
            return true;
        }
        return false;
    }

    private void doDisplay() {
        if (this.mDisplayWidget != null) {
            Component display = this.mDisplayWidget.getComponent();
            String sliderValue = Integer.toString(this.getComponent().getValue());
            CUtilDisplay.display(display, sliderValue);
        }
    }

    @NotNull
    public JSlider getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Slider.name();
    }
}

