/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingToggleButton;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingCheckBox
extends CSwingToggleButton {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingCheckBox.class);
    private final JCheckBox mComponent = new JCheckBox();

    CSwingCheckBox(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("borderPaintedFlat", this::applyBorderPaintedFlat);
    }

    private boolean applyBorderPaintedFlat(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean value = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, value});
            this.getComponent().setBorderPaintedFlat(value);
            return true;
        }
        return false;
    }

    @NotNull
    public JCheckBox getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.CheckBox.name();
    }
}

