/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Dimension;
import javax.swing.Box;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingBoxRigidArea
extends CSwingJComponent {
    private Box.Filler mComponent;

    CSwingBoxRigidArea(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.createComponent(aAttributes);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("height", this::applyHeight);
        list.addHandler("width", this::applyWidth);
    }

    private void createComponent(@NotNull CJsonObject aAttributes) {
        Object o = aAttributes.getValue("width");
        int width = CUtilInteger.fromObject((Object)o, (int)10);
        o = aAttributes.getValue("height");
        int height = CUtilInteger.fromObject((Object)o, (int)10);
        Dimension d = new Dimension(width, height);
        this.mComponent = new Box.Filler(d, d, d);
    }

    private boolean applyHeight(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number || aValue instanceof String) {
            Dimension dim = this.mComponent.getMaximumSize();
            dim.height = CUtilInteger.fromObject((Object)aValue, (int)10);
            this.mComponent.setMaximumSize(dim);
            this.mComponent.setMinimumSize(dim);
            this.mComponent.setPreferredSize(dim);
            return true;
        }
        return false;
    }

    private boolean applyWidth(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number || aValue instanceof String) {
            Dimension dim = this.mComponent.getMaximumSize();
            dim.width = CUtilInteger.fromObject((Object)aValue, (int)10);
            this.mComponent.setMaximumSize(dim);
            this.mComponent.setMinimumSize(dim);
            this.mComponent.setPreferredSize(dim);
            return true;
        }
        return false;
    }

    @NotNull
    public Box.Filler getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.BoxRigidArea.name();
    }
}

