/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Dimension;
import javax.swing.Box;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingBoxHorizontalStrut
extends CSwingJComponent {
    private static final int WIDTH = 10;
    private static final int HEIGHT = 0;
    private final Box.Filler mComponent = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));

    CSwingBoxHorizontalStrut(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("width", this::applyWidth);
        list.addHandler("height", this::applyHeight);
    }

    private boolean applyWidth(@NotNull String aKey, @Nullable Object aValue) {
        int width = CUtilInteger.fromObject((Object)aValue, (int)10);
        Dimension dim = this.mComponent.getMinimumSize();
        dim.width = width;
        this.mComponent.setMinimumSize(dim);
        dim = this.mComponent.getMaximumSize();
        dim.width = width;
        this.mComponent.setMaximumSize(dim);
        dim = this.mComponent.getPreferredSize();
        dim.width = width;
        this.mComponent.setPreferredSize(dim);
        return true;
    }

    private boolean applyHeight(@NotNull String aKey, @Nullable Object aValue) {
        int height = CUtilInteger.fromObject((Object)aValue, (int)10);
        Dimension dim = this.mComponent.getMinimumSize();
        dim.height = height;
        this.mComponent.setMinimumSize(dim);
        dim = this.mComponent.getMaximumSize();
        dim.height = height;
        this.mComponent.setMaximumSize(dim);
        return true;
    }

    @NotNull
    public Box.Filler getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.BoxHorizontalStrut.name();
    }
}

