/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.database;

import de.sillysky.nyssr.database.EDatabaseType;
import de.sillysky.nyssr.database.IH2Database;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;

class CH2Database
implements IH2Database {
    private static final ILogger LOG = CLoggerFactory.getLogger(CH2Database.class);
    private static final int SB1_SIZE = 100;
    private Connection mConnection;
    private CStringProperties mProperties;

    CH2Database() {
    }

    public void activate(CStringProperties aProperties) throws CException {
        this.mProperties = aProperties;
        this.open();
    }

    @Override
    public void close() {
        if (this.mConnection != null) {
            try {
                this.mConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void deactivate() {
        this.close();
    }

    @Override
    public Connection getConnection() {
        return this.mConnection;
    }

    @Override
    public boolean isOpen() {
        return this.mConnection != null;
    }

    @Override
    public Connection open() throws CException {
        StringBuilder sb = new StringBuilder(100);
        String type = this.mProperties.get("database.type", "EMBEDDED");
        EDatabaseType type1 = EDatabaseType.valueOf(type);
        if (type1 == EDatabaseType.EMBEDDED) {
            String dbPath = this.mProperties.get("database.storage.path", ".");
            Path path = Paths.get(dbPath, new String[0]);
            if (!path.isAbsolute()) {
                path = Paths.get(CUtilPath.getCurrentPath(), dbPath);
            }
            String dbName = this.mProperties.get("database.name", "database");
            sb.append("jdbc:h2:");
            sb.append(CUtilString.ensureLastChar((String)path.toString(), (char)File.separatorChar));
            sb.append(dbName);
        } else {
            sb.append("jdbc:h2:mem:");
            String dbName = UUID.randomUUID().toString();
            sb.append(dbName);
        }
        String cipher = this.mProperties.get("database.cipher", "");
        if (CUtilString.isValid((String)cipher)) {
            sb.append(";CIPHER=");
            sb.append(cipher);
        }
        String url = sb.toString();
        String userId = this.mProperties.get("database.user.id", "");
        String userPw = this.mProperties.get("database.user.password", "");
        String databasePw = this.mProperties.get("database.db.password", "");
        StringBuilder sb2 = new StringBuilder(100);
        if (CUtilString.isValid((String)databasePw)) {
            sb2.append(databasePw);
            sb2.append(" ");
        }
        if (CUtilString.isValid((String)userPw)) {
            sb2.append(userPw);
        }
        try {
            Class.forName("org.h2.Driver");
            String pw = sb2.toString();
            this.mConnection = DriverManager.getConnection(url, userId, pw);
            LOG.info("H2 database successfully opened: {}", new Object[]{url});
            return this.mConnection;
        }
        catch (Throwable e) {
            LOG.error(e, "Exception on opening the database: URL = {}, {}", new Object[]{url});
            throw new CException(2).append((Object)e);
        }
    }
}

