/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.web.protocol.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

public final class CRecordWebSetStylesForElements
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"8a6a97e6-e628-49e4-a8ed-936b82779bff");
    public static final String NAME = "WebSetStylesForElements";
    public static final String DESCRIPTION = "Set a style for all elements matching the selector.";
    public static final String SLOT_SELECTOR = "1";
    public static final String SLOT_STYLES = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getSelector(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SELECTOR);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CStringProperties getStyles(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_STYLES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static void setSelector(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SELECTOR, slot);
    }

    public static void setStyles(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_STYLES, slot);
    }
}

