/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.factory;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.tcp.factory.CTargetForTcpFactory;
import de.sillysky.nyssr.impl.tcp.factory.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.tcp.ITcpClient;
import de.sillysky.nyssr.tcp.ITcpFactory;
import de.sillysky.nyssr.tcp.ITcpServer;
import de.sillysky.nyssr.tcp.records.CRecordTcpNotifyClientCreated;
import de.sillysky.nyssr.tcp.records.CRecordTcpNotifyClientDeleted;
import de.sillysky.nyssr.tcp.records.CRecordTcpNotifyServerCreated;
import de.sillysky.nyssr.tcp.records.CRecordTcpNotifyServerDeleted;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTcpFactory
implements ITcpFactory,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpFactory.class);
    private final Map<UUID, ITcpClient> mClients = new ConcurrentHashMap<UUID, ITcpClient>();
    private final Map<UUID, ITcpServer> mServers = new ConcurrentHashMap<UUID, ITcpServer>();
    private final IDependencies mDependencies;
    private CTargetForTcpFactory mTarget;
    private Exception mException = null;

    CTcpFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        CStringProperties properties;
        boolean enabled;
        Preferences singlePreferences;
        String[] children;
        Preferences preferences;
        LOG.debug("Activate {}", new Object[]{this.getClass().getSimpleName()});
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TCP_FACTORY, "TCP_FACTORY");
        this.mTarget = new CTargetForTcpFactory(this.mDependencies, this);
        ns.getTargetRegistry().registerTarget((ITarget)this.mTarget, CWellKnownTID.TCP_FACTORY);
        if (this.mException == null) {
            this.mException = new Exception();
        } else {
            LOG.error("Activate failed", new Object[]{this.mException});
        }
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences tcpPreferences = kc.getPreferences("tcp");
        try {
            preferences = tcpPreferences.node("server");
            for (String child : children = preferences.childrenNames()) {
                singlePreferences = preferences.node(child);
                enabled = singlePreferences.getBoolean("enabled", true);
                if (enabled) {
                    properties = kc.readProperties(singlePreferences);
                    this.createServerById(properties);
                    continue;
                }
                LOG.debug("Skip server {} (disabled)", new Object[]{child});
            }
        }
        catch (BackingStoreException e) {
            LOG.error((Throwable)e, "Error creating TCP Server");
        }
        try {
            preferences = tcpPreferences.node("client");
            for (String child : children = preferences.childrenNames()) {
                singlePreferences = preferences.node(child);
                enabled = singlePreferences.getBoolean("enabled", true);
                if (enabled) {
                    properties = kc.readProperties(singlePreferences);
                    this.createClientsById(null, properties);
                    continue;
                }
                LOG.debug("Skip client {} (disabled)", new Object[]{child});
            }
        }
        catch (BackingStoreException e) {
            LOG.error((Throwable)e, "Error creating TCP Client");
        }
        aServiceRegistry.registerService(ITcpFactory.class, (Object)this);
    }

    @Override
    public void createClient(@Nullable CTargetAddress aOwner, @NotNull UUID aId, @NotNull String aHost, int aPort, boolean aEnableTls, @Nullable String aTlsProtocols, @Nullable String aTlsCipherSuites, long aRetryTimeout, boolean aFailOnFirstConnect, boolean aWantRetryMsg, int aInputBufferSize) throws CException {
        if (CUtilUuid.isEmpty((UUID)aId)) {
            throw new CException(7).append("Invalid ID. ID must be an UUID.toString();");
        }
        if (CUtilString.isEmpty((String)aHost)) {
            throw new CException(7).append("Invalid host.");
        }
        if (aPort <= 0) {
            throw new CException(7).append("Invalid port.");
        }
        ITcpClient client = this.getClient(aId);
        if (client != null) {
            throw new CException(11).append("Client ID already exists.");
        }
        client = this.getClient(aHost, aPort);
        if (client != null) {
            throw new CException(11).append("Client Host/Port already exists.");
        }
        CStringProperties p = new CStringProperties();
        p.put("id", aId.toString());
        p.put("host", aHost);
        p.put("port", Integer.toString(aPort));
        p.put("tls.enabled", Boolean.toString(aEnableTls));
        p.put("tls.protocols", CUtilString.nonEmpty((String)aTlsProtocols, (String)""));
        p.put("tls.cipher.suites", CUtilString.nonEmpty((String)aTlsCipherSuites, (String)""));
        p.put("retry.timeout", Long.toString(aRetryTimeout));
        p.put("input.buffer.size", Integer.toString(aInputBufferSize));
        p.put("fail.on.first.connect", Boolean.toString(aFailOnFirstConnect));
        p.put("want.retry.msg", Boolean.toString(aWantRetryMsg));
        client = this.mDependencies.getTcpClientFactory().createClient(aOwner, p);
        this.mClients.put(aId, client);
        this.notifyClientCreated(client);
    }

    private void createClientsById(@Nullable CTargetAddress aOwner, @NotNull CStringProperties aProperties) {
        try {
            ITcpClient client = this.mDependencies.getTcpClientFactory().createClient(aOwner, aProperties);
            this.notifyClientCreated(client);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error creating TCP Client.");
        }
    }

    @Override
    public void createServer(@NotNull UUID aId, int aPort, boolean aTlsEnabled, String aTlsProtocols, String aTlsCipherSuites, int aInputBufferSize) throws CException {
        if (CUtilUuid.isEmpty((UUID)aId)) {
            throw new CException(7).append("Invalid ID. ID must be an UUID.toString();");
        }
        if (aPort <= 0) {
            throw new CException(7).append("Invalid port.");
        }
        ITcpServer server = this.getServer(aId);
        if (server != null) {
            throw new CException(11).append("Server ID already exists.");
        }
        server = this.getServer(aPort);
        if (server != null) {
            throw new CException(11).append("Server Port already exists.");
        }
        CStringProperties p = new CStringProperties();
        p.put("id", aId.toString());
        p.put("port", Integer.toString(aPort));
        p.put("tls.enabled", Boolean.toString(aTlsEnabled));
        p.put("tls.protocols", CUtilString.nonEmpty((String)aTlsProtocols, (String)""));
        p.put("tls.cipher.suites", CUtilString.nonEmpty((String)aTlsCipherSuites, (String)""));
        p.put("input.buffer.size", Integer.toString(aInputBufferSize));
        server = this.mDependencies.getTcpServerFactory().createServer(p);
        this.notifyServerCreated(server);
    }

    private void createServerById(CStringProperties aProperties) {
        try {
            ITcpServer server = this.mDependencies.getTcpServerFactory().createServer(aProperties);
            this.notifyServerCreated(server);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error creating TCP Server.");
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mTarget.deregisterTarget();
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public UUID deleteClient(@NotNull String aHost, int aPort) throws CException {
        ITcpClient client = this.getClient(aHost, aPort);
        if (client == null) {
            throw new CException(5).append("Unknown TCP client " + aHost + ":" + aPort);
        }
        UUID id = client.getID();
        this.mClients.remove(id);
        this.mDependencies.getTcpClientFactory().deleteClient(client);
        this.notifyClientDeleted(client);
        return id;
    }

    @Override
    public void deleteClient(@NotNull UUID aID) throws CException {
        ITcpClient client = this.getClient(aID);
        if (client == null) {
            throw new CException(5).append("Unknown TCP client " + String.valueOf(aID));
        }
        client.dispose();
        this.mClients.remove(aID);
        this.mDependencies.getTcpClientFactory().deleteClient(client);
        this.notifyClientDeleted(client);
    }

    @Override
    public UUID deleteServer(int aPort) throws CException {
        ITcpServer server = this.getServer(aPort);
        if (server == null) {
            throw new CException(5).append("Unknown TCP server on port " + aPort);
        }
        UUID id = server.getID();
        this.mServers.remove(id);
        this.mDependencies.getTcpServerFactory().deleteTcpServer(server);
        this.notifyServerDeleted(server);
        return id;
    }

    @Override
    public void deleteServer(@NotNull UUID aID) throws CException {
        ITcpServer server = this.getServer(aID);
        if (server == null) {
            throw new CException(5).append("Unknown TCP server with ID " + String.valueOf(aID));
        }
        this.mServers.remove(aID);
        this.mDependencies.getTcpServerFactory().deleteTcpServer(server);
        this.notifyServerDeleted(server);
    }

    private ITcpClient getClient(UUID aID) {
        return this.mClients.get(aID);
    }

    private ITcpClient getClient(String aHost, int aPort) {
        for (ITcpClient c : this.mClients.values()) {
            if (!c.match(aHost, aPort)) continue;
            return c;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<ITcpClient> getClients() {
        return new ArrayList<ITcpClient>(this.mClients.values());
    }

    private ITcpServer getServer(UUID aID) {
        return this.mServers.get(aID);
    }

    private ITcpServer getServer(int aPort) {
        for (ITcpServer s : this.mServers.values()) {
            if (s.getPort() != aPort) continue;
            return s;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<ITcpServer> getServers() {
        return new ArrayList<ITcpServer>(this.mServers.values());
    }

    private void notifyClientCreated(ITcpClient aClient) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordTcpNotifyClientCreated.class);
            CRecord rec = CRecordTcpNotifyClientCreated.create();
            CRecordTcpNotifyClientCreated.setId((CRecord)rec, (UUID)aClient.getID());
            CRecordTcpNotifyClientCreated.setHost((CRecord)rec, (String)aClient.getHost());
            CRecordTcpNotifyClientCreated.setPort((CRecord)rec, (int)aClient.getPort());
            this.mTarget.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending {}: ", new Object[]{CRecordTcpNotifyClientCreated.class.getSimpleName()});
        }
    }

    private void notifyClientDeleted(ITcpClient aClient) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordTcpNotifyClientDeleted.class);
            CRecord rec = CRecordTcpNotifyClientDeleted.create();
            CRecordTcpNotifyClientDeleted.setId((CRecord)rec, (UUID)aClient.getID());
            CRecordTcpNotifyClientCreated.setHost((CRecord)rec, (String)aClient.getHost());
            CRecordTcpNotifyClientDeleted.setPort((CRecord)rec, (int)aClient.getPort());
            this.mTarget.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending {}: ", new Object[]{CRecordTcpNotifyClientDeleted.class.getSimpleName()});
        }
    }

    private void notifyServerCreated(ITcpServer aServer) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordTcpNotifyServerCreated.class);
            CRecord rec = CRecordTcpNotifyServerCreated.create();
            CRecordTcpNotifyServerCreated.setPort((CRecord)rec, (int)aServer.getPort());
            CRecordTcpNotifyServerCreated.setId((CRecord)rec, (UUID)aServer.getID());
            this.mTarget.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending {}: ", new Object[]{CRecordTcpNotifyServerCreated.class.getSimpleName()});
        }
    }

    private void notifyServerDeleted(ITcpServer aServer) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordTcpNotifyServerDeleted.class);
            CRecord rec = CRecordTcpNotifyServerDeleted.create();
            CRecordTcpNotifyServerDeleted.setPort((CRecord)rec, (int)aServer.getPort());
            CRecordTcpNotifyServerDeleted.setId((CRecord)rec, (UUID)aServer.getID());
            this.mTarget.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending {}: ", new Object[]{CRecordTcpNotifyServerDeleted.class.getSimpleName()});
        }
    }
}

