/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.factory;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.factory.CTcpFactory;
import de.sillysky.nyssr.impl.tcp.factory.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.tcp.ITcpClient;
import de.sillysky.nyssr.tcp.ITcpServer;
import de.sillysky.nyssr.tcp.records.CRecordTcpClient;
import de.sillysky.nyssr.tcp.records.CRecordTcpCreateClient;
import de.sillysky.nyssr.tcp.records.CRecordTcpCreateServer;
import de.sillysky.nyssr.tcp.records.CRecordTcpDeleteClient;
import de.sillysky.nyssr.tcp.records.CRecordTcpDeleteServer;
import de.sillysky.nyssr.tcp.records.CRecordTcpGetClientList;
import de.sillysky.nyssr.tcp.records.CRecordTcpGetServerList;
import de.sillysky.nyssr.tcp.records.CRecordTcpServer;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class CTargetForTcpFactory
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTcpFactory.class);
    private final IDependencies mDependencies;
    private final CTcpFactory mFactory;

    CTargetForTcpFactory(@NotNull IDependencies aDependencies, @NotNull CTcpFactory aFactory) {
        this.mDependencies = aDependencies;
        this.mFactory = aFactory;
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordTcpCreateClient.ID, this::asyncCreateTcpClient);
        this.addMessageHandler(CRecordTcpDeleteClient.ID, this::asyncDeleteTcpClient);
        this.addMessageHandler(CRecordTcpCreateServer.ID, this::asyncCreateTcpServer);
        this.addMessageHandler(CRecordTcpDeleteServer.ID, this::asyncDeleteTcpServer);
        this.addMessageHandler(CRecordTcpGetClientList.ID, this::asyncGetTcpClientList);
        this.addMessageHandler(CRecordTcpGetServerList.ID, this::asyncGetTcpServerList);
    }

    private boolean asyncCreateTcpClient(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID id = CRecordTcpCreateClient.getId((CRecord)aRecord, null);
        String host = CRecordTcpCreateClient.getHost((CRecord)aRecord, (String)"");
        int port = CRecordTcpCreateClient.getPort((CRecord)aRecord, (int)0);
        boolean tlsEnabled = CRecordTcpCreateClient.getTlsEnabled((CRecord)aRecord, (boolean)false);
        String tlsProtocols = CRecordTcpCreateClient.getTlsProtocols((CRecord)aRecord, (String)"");
        String tlsCipherSuites = CRecordTcpCreateClient.getTlsCipherSuites((CRecord)aRecord, (String)"");
        long retryTimeout = CRecordTcpCreateClient.getRetryTimeout((CRecord)aRecord, (long)0L);
        int inputBufferSize = CRecordTcpCreateClient.getInputBufferSize((CRecord)aRecord, (int)270000);
        boolean failOnFirstConnect = CRecordTcpCreateClient.getFailOnFirstConnect((CRecord)aRecord, (boolean)false);
        boolean wantUpdateOnRetry = CRecordTcpCreateClient.getWantUpdateOnRetry((CRecord)aRecord, (boolean)false);
        this.mFactory.createClient(aEnvelope.getSender(), id, host, port, tlsEnabled, tlsProtocols, tlsCipherSuites, retryTimeout, failOnFirstConnect, wantUpdateOnRetry, inputBufferSize);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCreateTcpServer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID id = CRecordTcpCreateServer.getId((CRecord)aRecord, null);
        int port = CRecordTcpCreateServer.getPort((CRecord)aRecord, (int)0);
        boolean tlsEnabled = CRecordTcpCreateServer.getTlsEnabled((CRecord)aRecord, (boolean)false);
        String tlsProtocols = CRecordTcpCreateServer.getTlsProtocols((CRecord)aRecord, (String)"");
        String tlsCipherSuites = CRecordTcpCreateServer.getTlsCipherSuites((CRecord)aRecord, (String)"");
        int inputBufferSize = CRecordTcpCreateServer.getInputBufferSize((CRecord)aRecord, (int)270000);
        this.mFactory.createServer(id, port, tlsEnabled, tlsProtocols, tlsCipherSuites, inputBufferSize);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteTcpClient(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID id = CRecordTcpDeleteClient.getId((CRecord)aRecord, null);
        if (CUtilUuid.isValid((UUID)id)) {
            this.mFactory.deleteClient(id);
        } else {
            String host = CRecordTcpDeleteClient.getHost((CRecord)aRecord, (String)"");
            int port = CRecordTcpDeleteClient.getPort((CRecord)aRecord, (int)0);
            this.mFactory.deleteClient(host, port);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteTcpServer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID id = CRecordTcpDeleteServer.getId((CRecord)aRecord, null);
        if (CUtilUuid.isValid((UUID)id)) {
            this.mFactory.deleteServer(id);
        } else {
            int port = CRecordTcpDeleteServer.getPort((CRecord)aRecord, (int)0);
            this.mFactory.deleteServer(port);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetTcpClientList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection<ITcpClient> clients = this.mFactory.getClients();
        CRecord[] records = new CRecord[clients.size()];
        int i = 0;
        for (ITcpClient c : clients) {
            records[i] = this.createClientRecord(c);
            ++i;
        }
        CRecordTcpGetClientList.setClients((CRecord)aRecord, (CRecord[])records);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetTcpServerList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection<ITcpServer> servers = this.mFactory.getServers();
        CRecord[] records = new CRecord[servers.size()];
        int i = 0;
        for (ITcpServer s : servers) {
            records[i] = this.createServerRecord(s);
            ++i;
        }
        CRecordTcpGetServerList.setServers((CRecord)aRecord, (CRecord[])records);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(this.getAddress(), "TcpFactory");
        CRecordHelper.addObserver(CRecordTcpCreateClient.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordTcpDeleteClient.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordTcpCreateServer.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordTcpDeleteServer.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordTcpGetClientList.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordTcpGetServerList.class, (ITarget)this, (boolean)false);
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    private CRecord createClientRecord(@NotNull ITcpClient aClient) throws CException {
        CRecord rec = CRecordTcpClient.create();
        CRecordTcpClient.setTlsEnabled((CRecord)rec, (boolean)aClient.isTlsEnabled());
        CRecordTcpClient.setTlsProtocols((CRecord)rec, (String)aClient.getTlsProtocols());
        CRecordTcpClient.setTlsCipherSuites((CRecord)rec, (String)aClient.getTlsCipherSuites());
        CRecordTcpClient.setHost((CRecord)rec, (String)aClient.getHost());
        CRecordTcpClient.setId((CRecord)rec, (UUID)aClient.getID());
        CRecordTcpClient.setInputBufferSize((CRecord)rec, (int)aClient.getInputBufferSize());
        CRecordTcpClient.setIsConnected((CRecord)rec, (boolean)aClient.isConnected());
        CRecordTcpClient.setLocalPort((CRecord)rec, (int)aClient.getLocalPort());
        CRecordTcpClient.setPort((CRecord)rec, (int)aClient.getPort());
        CRecordTcpClient.setRetryTimeout((CRecord)rec, (long)aClient.getRetryTimeout());
        return rec;
    }

    @NotNull
    private CRecord createServerRecord(@NotNull ITcpServer aServer) throws CException {
        CRecord rec = CRecordTcpServer.create();
        CRecordTcpServer.setTlsEnabled((CRecord)rec, (boolean)aServer.isTlsEnabled());
        CRecordTcpServer.setTlsProtocols((CRecord)rec, (String)aServer.getTlsProtocols());
        CRecordTcpServer.setTlsCipherSuites((CRecord)rec, (String)aServer.getTlsCipherSuites());
        CRecordTcpServer.setId((CRecord)rec, (UUID)aServer.getID());
        CRecordTcpServer.setInputBufferSize((CRecord)rec, (int)aServer.getInputBufferSize());
        CRecordTcpServer.setPort((CRecord)rec, (int)aServer.getPort());
        return rec;
    }
}

