/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.tcp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CStreamOutput {
    private final byte[] mChunkHeader;
    private final DataOutputStream mStream;

    public CStreamOutput(byte[] aChunkHeader, @NotNull OutputStream aStream) {
        this.mChunkHeader = aChunkHeader;
        this.mStream = new DataOutputStream(aStream);
    }

    public void put(byte[] aBytes) throws IOException {
        if (aBytes != null && aBytes.length > 0) {
            this.mStream.write(this.mChunkHeader);
            this.mStream.writeInt(aBytes.length);
            this.mStream.write(aBytes);
            this.mStream.flush();
        }
    }

    public void put(byte[] aBytes, int aPosition, int aLength) throws IOException {
        if (aBytes != null && aPosition + aLength >= aBytes.length) {
            this.mStream.write(this.mChunkHeader);
            this.mStream.writeInt(aLength);
            this.mStream.write(aBytes, aPosition, aLength);
            this.mStream.flush();
        }
    }
}

