/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.rectangle;

import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.arguments.CArgumentList;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilRectangle {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String W = "w";
    public static final String H = "h";
    public static final String DELIMITER2 = "=";
    public static final String DELIMITER1 = ",";
    public static final String ZERO = "0";

    private CUtilRectangle() {
    }

    public static Rectangle unpack(@Nullable Object aValue, @Nullable Rectangle aDefault) {
        if (aValue instanceof Rectangle) {
            return (Rectangle)aValue;
        }
        if (aValue instanceof String) {
            return CUtilRectangle.unpack((String)aValue);
        }
        if (aValue instanceof CStringProperties) {
            return CUtilRectangle.unpack((CStringProperties)aValue);
        }
        return aDefault;
    }

    @Nullable
    private static Rectangle unpack(@NotNull String aValue) {
        if (aValue.indexOf(DELIMITER2) > 0) {
            CStringProperties sp = new CArgumentList().toLower().split(aValue).parseProperties(0, DELIMITER2);
            return CUtilRectangle.unpack(sp);
        }
        String[] split = aValue.split(DELIMITER1);
        if (split.length == 4) {
            int x = CUtilInteger.fromString(split[0], 0);
            int y = CUtilInteger.fromString(split[1], 0);
            int width = CUtilInteger.fromString(split[2], 0);
            int height = CUtilInteger.fromString(split[3], 0);
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    @NotNull
    private static Rectangle unpack(@NotNull CStringProperties aValue) {
        String s = aValue.get(X, ZERO);
        int x = CUtilInteger.fromString(s, 0);
        s = aValue.get(Y, ZERO);
        int y = CUtilInteger.fromString(s, 0);
        s = aValue.get(W, ZERO);
        int width = CUtilInteger.fromString(s, 0);
        s = aValue.get(H, ZERO);
        int height = CUtilInteger.fromString(s, 0);
        return new Rectangle(x, y, width, height);
    }
}

