/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.hash.CHash;
import de.sillysky.nyssr.util.hash.CHashUnknown;
import de.sillysky.nyssr.util.hash.EHashType;
import de.sillysky.nyssr.util.hash.IDigest;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHashFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHashFactory.class);

    private CHashFactory() {
    }

    @NotNull
    public static EHashType algorithmToType(@NotNull String aAlgorithm) {
        switch (aAlgorithm) {
            case "MD2": {
                return EHashType.MD2;
            }
            case "MD5": {
                return EHashType.MD5;
            }
            case "SHA-1": {
                return EHashType.SHA1;
            }
            case "SHA-256": {
                return EHashType.SHA256;
            }
            case "SHA-384": {
                return EHashType.SHA384;
            }
            case "SHA-512": {
                return EHashType.SHA512;
            }
        }
        return EHashType.EMPTY;
    }

    @NotNull
    public static IDigest createEmpty() {
        return new CHash();
    }

    @Nullable
    public static IDigest createEmpty(@NotNull EHashType aType) {
        String algorithm = CHashFactory.typeToAlgorithm(aType);
        if (!algorithm.isEmpty()) {
            try {
                return new CHash(algorithm, aType);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("No such Algorithm {}.", new Object[]{aType});
            }
        }
        return null;
    }

    @Nullable
    public static IDigest fromByteArray(@NotNull EHashType aType, byte[] aHashArray) {
        String algorithm = CHashFactory.typeToAlgorithm(aType);
        if (algorithm.isEmpty()) {
            return new CHashUnknown(EHashType.EMPTY, aHashArray);
        }
        try {
            return new CHash(algorithm, aType, aHashArray);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("No such Algorithm {}.", new Object[]{aType});
            return null;
        }
    }

    @Nullable
    public static IDigest fromByteArray(@NotNull EHashType aType, byte[] aHashArray, int aPosition, int aLength) {
        String algorithm = CHashFactory.typeToAlgorithm(aType);
        byte[] digest = new byte[aLength];
        System.arraycopy(aHashArray, aPosition, digest, 0, aLength);
        if (algorithm.isEmpty()) {
            return new CHashUnknown(EHashType.EMPTY, digest);
        }
        try {
            return new CHash(algorithm, aType, digest);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("No such Algorithm {}.", new Object[]{aType});
            return null;
        }
    }

    public static IDigest fromByteArray(byte[] aData, @NotNull EHashType aType) {
        IDigest hash = CHashFactory.createEmpty(aType);
        if (hash != null) {
            hash.update(aData, 0, aData.length);
            hash.digest();
        }
        return hash;
    }

    @Nullable
    public static IDigest fromList(@Nullable List<?> aList) {
        IDigest result = null;
        if (aList != null && aList.size() == 2) {
            byte[] digest;
            EHashType type;
            Object object0 = aList.get(0);
            if (object0 instanceof EHashType) {
                type = (EHashType)((Object)object0);
            } else if (object0 instanceof Byte) {
                type = EHashType.getSave((Byte)object0);
            } else if (object0 instanceof String) {
                type = EHashType.valueOf((String)object0);
            } else {
                return null;
            }
            Object object1 = aList.get(1);
            if (object1 instanceof byte[]) {
                digest = (byte[])object1;
            } else if (object1 instanceof String) {
                digest = CUtilByteArray.fromString((String)object1);
            } else {
                return null;
            }
            result = CHashFactory.fromByteArray(type, digest);
        }
        return result;
    }

    @NotNull
    public static IDigest fromStream(@NotNull DataInput aStream) throws IOException {
        byte typeByte = aStream.readByte();
        EHashType type = EHashType.getSave(typeByte);
        IDigest hash = CHashFactory.createEmpty(type);
        if (hash == null) {
            short length = aStream.readShort();
            byte[] bb = new byte[length];
            aStream.readFully(bb);
            return new CHashUnknown(type, bb);
        }
        short size = aStream.readShort();
        byte[] bb = new byte[size];
        aStream.readFully(bb);
        hash.setDigest(bb);
        return hash;
    }

    @Nullable
    public static IDigest fromStreamedBytes(byte[] aBytes) {
        IDigest result = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(aBytes);
             DataInputStream dis = new DataInputStream(bis);){
            result = CHashFactory.fromStream(dis);
        }
        catch (IOException e) {
            LOG.error("Error reading hash from stream: {}.", e.getMessage());
        }
        return result;
    }

    @Nullable
    public static IDigest fromString(@NotNull String aString) {
        IDigest result = null;
        String[] parts = aString.split(":");
        if (parts.length == 2) {
            EHashType type = CHashFactory.algorithmToType(parts[0]);
            byte[] bytes = CUtilByteArray.fromString(parts[1]);
            result = CHashFactory.fromByteArray(type, bytes);
        }
        return result;
    }

    @NotNull
    public static String toString(IDigest aDigest, int aMaxLength) {
        CUtilCheck.checkNotNull(aDigest, "Digest is null", new Object[0]);
        return CUtilByteArray.toString(aDigest.getByteArray(), ',', aMaxLength);
    }

    @Contract(pure=true)
    @NotNull
    public static String typeToAlgorithm(@NotNull EHashType aType) {
        switch (aType) {
            case MD2: {
                return "MD2";
            }
            case MD5: {
                return "MD5";
            }
            case SHA1: {
                return "SHA-1";
            }
            case SHA256: {
                return "SHA-256";
            }
            case SHA384: {
                return "SHA-384";
            }
            case SHA512: {
                return "SHA-512";
            }
        }
        return "";
    }
}

