/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.factory;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFactory.class);
    private final AtomicBoolean mValid = new AtomicBoolean(false);

    protected CFactory() {
        LOG.info("--------- {} 0", this.getClass().getSimpleName());
    }

    public void dismiss() {
        if (this.mValid.get()) {
            this.mValid.set(false);
            LOG.info("--------- {} 0", this.getClass().getSimpleName());
        }
    }

    protected final boolean isValid() {
        boolean valid = this.mValid.get();
        if (!valid) {
            LOG.warn("{} has been dismissed.", this.getClass().getSimpleName());
        }
        return valid;
    }

    protected final void validate() {
        boolean valid = this.mValid.get();
        if (!valid) {
            this.mValid.set(true);
            LOG.info("--------- {} 1", this.getClass().getSimpleName());
        }
    }
}

