/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.timer;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTimer {
    private final ITimerManager mManager;
    private final CTargetAddress mAddress;
    private final IId mId;
    private final boolean mRepeat;
    private final CRecord mTemplate;
    private long mDelay;
    private long mHandle = 0L;
    private int mCounter = 0;

    public CTimer(@NotNull ITimerManager aManager, @NotNull IId aId, @NotNull CTargetAddress aAddress, long aDelay, boolean aRepeat, @Nullable CRecord aTemplate) {
        this.mManager = aManager;
        this.mAddress = aAddress;
        this.mId = aId;
        this.mDelay = aDelay;
        this.mRepeat = aRepeat;
        this.mTemplate = aTemplate;
    }

    public long getDelay() {
        return this.mDelay;
    }

    public void notifyTriggerOccurred() {
        this.mHandle = 0L;
    }

    public void setDelay(long aDelay) {
        this.mDelay = aDelay;
    }

    public void startIf() {
        if (this.mHandle == 0L) {
            this.mHandle = this.mManager.createAndStartTimer(this.mId, this.mAddress, this.mDelay, this.mRepeat, this.mTemplate);
            ++this.mCounter;
        }
    }

    public void startIfElseReset() {
        if (this.mHandle == 0L) {
            this.mHandle = this.mManager.createAndStartTimer(this.mId, this.mAddress, this.mDelay, this.mRepeat, this.mTemplate);
            ++this.mCounter;
        } else {
            this.mManager.resetTimer(this.mHandle);
        }
    }

    public void dismiss() {
        if (this.mHandle != 0L) {
            this.mManager.dismissTimer(this.mHandle);
            this.mHandle = 0L;
        }
    }

    public int getCounter() {
        return this.mCounter;
    }

    public void resetCounter() {
        this.mCounter = 0;
    }
}

