/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.namespace.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordCreateNamespace
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("9f9dfda5-21aa-4fb9-a15f-5dccef2612e0");
    public static final String NAME = "CreateNamespace";
    public static final String DESCRIPTION = "Create, register and start a Namespace.";
    public static final String SLOT_CREATED_NID = "cnId";
    public static final String SLOT_DESCRIPTION = "desc";
    public static final String SLOT_WANTED_NID = "wnId";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getCreatedNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CREATED_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static String getDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getWantedNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_WANTED_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setCreatedNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_CREATED_NID, slot);
    }

    public static void setDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_DESCRIPTION, slot);
    }

    public static void setWantedNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_WANTED_NID, slot);
    }
}

